import json
import base64
import requests
import os
from openai import OpenAI

class Debug_with_GPT4V():
    def __init__(self, api_key, base_url=""):
        self.client = OpenAI(
            api_key=api_key,
            base_url=base_url,
        )

    def encode_image(self, image_path):
        with open(image_path, "rb") as image_file:
            return base64.b64encode(image_file.read()).decode('utf-8')

    def ask_image(self, image_path, history, question):
        base64_image = self.encode_image(image_path)
        messages = history + [
            {
                "role": "user",
                "content": [
                    {
                        "type": "text",
                        "text": question
                    },
                    {
                        "type": "image_url",
                        "image_url": {
                            "url": f"data:image/jpeg;base64,{base64_image}"
                        }
                    }
                ]
            }
        ]
        
        response = self.client.chat.completions.create(messages=messages, model="gpt-4o")

        try:
            return response.choices[0].message.content
        except:
            print('ERROR:', response)
            return json.dumps({})

    def ask_text(self, history, question):
        messages = history + [
            {
                "role": "user",
                "content": [
                    {
                        "type": "text",
                        "text": question
                    }
                ]
            }
        ]
        response = self.client.chat.completions.create(messages=messages, model="gpt-4o")

        try:
            return response.choices[0].message.content
        except:
            print('ERROR:', response)
            return json.dumps({})

    def ask_multiimage(self, image_paths, history, question):
        images = []
        for path in image_paths:
            base64_image = self.encode_image(path)
            images.append({
                "type": "image_url",
                "image_url": {
                    "url": f"data:image/jpeg;base64,{base64_image}"
                }
            })
        messages = history + [
            {
            "role": "user",
            "content": [
                {
                "type": "text",
                "text": question
                },
            ] + images
            }]
        response = self.client.chat.completions.create(messages=messages, model="gpt-4o")
        try:
            return response.choices[0].message.content
        except:
            print('ERROR:', response)
            return json.dumps({})

