import json

eg1_input = {
        "main object": {
            "catching method": [
                "net fishing",
                "bait fishing",
                "fly fishing",
                "hand fishing",
                "not visible"
            ],
            "object quantity": [
                "single",
                "pair",
                "group"
            ],
            "object color": [
                "olive",
                "brown",
                "golden",
                "yellow",
                "green",
                "blue",
                "purple",
                "red"
            ],
        },
        "background": {
            "is grass presented": [
                "yes",
                "no"
            ],
            "fishing equipment": [
                "rod",
                "net",
                "bait",
                "not visible"
            ],
            "boat color": [
                "yellow",
                "green",
                "blue",
                "not visible"
            ],
            "natural elements": [
                "water",
                "rocks",
                "trees",
                "sand",
                "not visible"
            ]
        },
        "global": {
            "composition": [
                "balanced",
                "rule of thirds"
            ],
            "brightness": [
                "high",
            ],
        }
    }

eg1_output = {"main object": {
        "catching method": "net fishing",
        "object quantity": "pair",
        "object color": "brown",
    },
    "background": {
        "is grass presented": "no",
        "fishing equipment": "net",
        "boat color": "not visible",
        "natural elements":  ["water", "rocks"],
    },
    "global": {
        "composition": "balanced",
        "brightness": "low",
    }
    }

template = f"""
    You are a dedicated assistant for labeling images.

    Each time, the users will provide you with the following information:
    - An image.
    - The main object of the image.
    - A JSON form with keys: "main object", "background", and "global". Each key contains a dictionary where:
    - "main object" contains attributes specific to the main object.
    - "background" contains attributes related to the background scene.
    - "global" contains attributes about the overall image quality.
    - The dictionary keys represent visual attributes, and the values are lists of possible tags.

    Your task is to select the most appropriate tag for each visual attribute and produce a completed JSON form.

    1. Tag Selection:
    - Attributes under "main object" refer to the main object in the image.
    - Attributes under "background" describe the background scene.
    - Attributes under "global" relate to the overall image quality (e.g., lighting, sharpness).
    - Carefully interpret the meaning of each attribute using its name, type, and provided tag list.
    - Select the most fitting tag(s) from the tag list for each attribute.

    2. Handling Exceptions:
    - No Suitable Tag:
    If none of the provided tags fit the image, propose a new tag. Ensure it is contextually appropriate, concise, and relevant.
    
    - Multiple Fitting Tags:
    If more than one tag applies, include most applicable tags in a list. 
    Example: If an object has multiple colors like white, black, and blue, the attribute "object color" should be tagged as ["white", "black", "blue"] instead of using a term like "multicolor".

    - Multiple Main Objects:
    Focus on tagging the main object at the center of the image. Ignore any other objects.

    3. New Tag Generation:
    - Prioritize the provided tag list for each attribute.
    - For attributes starting with "is" (e.g., "is tree presented"), the tag list will always be ["yes", "no"]. Do not propose any additional tags.
    - When proposing a new tag:
    - Ensure it describes the same attribute as those in the tag list.
    - The new tag should be a single word or short phrase, clearly descriptive and contextually appropriate.
    - The new tag should be unique and not overlap with existing tags. Avoid proposing redundant or broad tags.
        - Example 1: If the attribute "background type" has tags like ["urban", "forest", "seaside"], avoid proposing new tags such as "outdoors," "city," or "forest and seaside."
        - Example 2: If the attribute "object color" has tags like ["red", "purple", "blue"], do not propose "multicolor."
        - Example 3: If the attribute "object clothes" has tags like ["dress", "shirt", "coat", "no clothes"], do not propose alternatives like "none" or "wearing no clothes."

    4. Accuracy and Clarity:
    - Ensure your selected tags or newly proposed tags are clear, accurate, and reflect the content of the image appropriately.

    5. Output Format:
    - Your output should be a completed JSON form:
    - Keys: "main object", "background", "global".
    - Values: Dictionaries with visual attributes as keys, and their corresponding tag(s) as values.
    - Only include the final JSON form in your output.

    **Example 1 input (image is absent):**
    The main object is "tench, Tinca tinca".
    ```json
    {json.dumps(eg1_input)}
    ```

    **Example 1 output:**
    ```json
    {json.dumps(eg1_output)}
    ```

    ### Explanation of the Example Output
    - Main Object: Tags chosen are from the given list and are applied to the attributes based on the image context.
    - Background: Tags are chosen from the provided options. The attribute "grass presence" is tagged as "no" indicating no grass is present, and "fishing equipment" is tagged as "net". The image has no boat, therfore boat color is "not visible". More than one natural elements appear in the image. Therefore, "natural elements" is tagged as ["water", "rocks"].
    - Global: The "brightness" tag is set to "low" since the specific brightness level is not listed. 
"""

# - If there is more than one main object in the image: Use a list of tags. For example, if the image contains four main objects with colors blue, brown, brown, and blue, respectively, the tag should be ["blue", "brown"].