import json
import base64
from textwrap import dedent
import prompts.config as config


class Prompts:
    def __init__(self):
        self.preare_eg_images()

    def preare_eg_images(self):
        with open(config.attr_eg_images['img11_path'], 'rb') as img11_file:
            self.attr_img11 = base64.b64encode(
                img11_file.read()).decode('utf-8')
        with open(config.attr_eg_images['img12_path'], 'rb') as img12_file:
            self.attr_img12 = base64.b64encode(
                img12_file.read()).decode('utf-8')
        with open(config.attr_eg_images['img21_path'], 'rb') as img21_file:
            self.attr_img21 = base64.b64encode(
                img21_file.read()).decode('utf-8')
        with open(config.attr_eg_images['img22_path'], 'rb') as img22_file:
            self.attr_img22 = base64.b64encode(
                img22_file.read()).decode('utf-8')

    def init_attrs_rules(self):
        rules = [
            {
                'role': 'system',
                'content': [
                    {
                        'type': 'text',
                        'text': dedent(config.init_attrs_template)
                    },
                ]
            },
            {
                'role': 'assistant',
                'content': 'Ok, I am your assistant. Now please givce me the class name.'
            },
        ]
        return rules
    
    def extract_dataset_attrs_rules(self):
        rules = [
            {
                'role': 'system',
                'content': [
                    {
                        'type': 'text',
                        'text': dedent(config.extract_dataset_attrs_template)
                    },
                ]
            },
            {
                'role': 'assistant',
                'content': 'Ok, I am your assistant. Now please show me the example.'
            },
            {
                'role': 'user',
                'content': [
                    {
                        'type': 'text',
                        'text': dedent(config.attr_example)
                    },
                    {
                        'type': 'image_url',
                        'image_url': {
                            'url': f'data:image/jpeg;base64,{self.attr_img11}'
                        }
                    },
                    {
                        'type': 'image_url',
                        'image_url': {
                            'url': f'data:image/jpeg;base64,{self.attr_img12}'
                        }
                    },
                    {
                        'type': 'image_url',
                        'image_url': {
                            'url': f'data:image/jpeg;base64,{self.attr_img21}'
                        }
                    },
                    {
                        'type': 'image_url',
                        'image_url': {
                            'url': f'data:image/jpeg;base64,{self.attr_img22}'
                        }
                    }
                ]
            },
            {
                'role': 'assistant',
                'content': 'Thanks for the examples. Now please show me the images and the json form.'
            },
        ]
        return rules

    def extract_clf_attrs_rules(self):
        rules = [
            {
                'role': 'system',
                'content': [
                    {
                        'type': 'text',
                        'text': dedent(config.extract_clf_attrs_template)
                    },
                ]
            },
            {
                'role': 'assistant',
                'content': 'Ok, I am your assistant. Now please givce me the two classes.'
            },
        ]
        return rules
    
    def extract_pose_attrs_rules(self):
        rules = [
            {
                'role': 'system',
                'content': [
                    {
                        'type': 'text',
                        'text': dedent(config.extract_pose_attrs_template)
                    },
                ]
            },
            {
                'role': 'assistant',
                'content': 'Ok, I am your assistant. Now please givce me the main class.'
            },
        ]
        return rules
    
    def extract_det_attrs_rules(self):
        rules = [
            {
                'role': 'system',
                'content': [
                    {
                        'type': 'text',
                        'text': dedent(config.extract_det_attrs_template)
                    },
                ]
            },
            {
                'role': 'assistant',
                'content': 'Ok, I am your assistant. Now please givce me the two classes.'
            },
        ]
        return rules
    
    def check_attrs_rules(self):
        rules = [
            {
                'role': 'system',
                'content': dedent(config.check_attrs_template)
            },
            {
                'role': 'assistant',
                'content': 'Ok, I am your assistant. Now please show me the json form.'
            }
        ]
        return rules

    def extract_tags_rules(self):
        rules = [
            {
                'role': 'system',
                'content': dedent(config.extract_tags_template)
            },
            {
                'role': 'assistant',
                'content': 'Ok, I am your assistant. Now please show me the json form.'
            }
        ]
        return rules

    def label_data_stage1_rules(self):
        rules = [
            {
                'role': 'system',
                'content': dedent(config.label_data_stage1_template)
            },
            {
                'role': 'assistant',
                'content': 'Ok, I am your assistant. Now please show me the json form and the image.'
            }
        ]
        return rules
    
    def label_data_stage2_rules(self):
        rules = [
            {
                'role': 'system',
                'content': dedent(config.label_data_stage2_template)
            },
            {
                'role': 'assistant',
                'content': 'Ok, I am your assistant. Now please show me the two json forms.'
            }
        ]
        return rules
    
    def label_data_stage3_rules(self):
        rules = [
            {
                'role': 'system',
                'content': dedent(config.label_data_stage3_template)
            },
            {
                'role': 'assistant',
                'content': 'Ok, I am your assistant. Now please show me the json form and the image.'
            }
        ]
        return rules

    def tag_description_rules(self):
        rules = [
            {
                'role': 'system',
                'content': dedent(config.tag_description_template)
            },
            {
                'role': 'assistant',
                'content': 'Ok, I am your assistant. Now please show me the json form.'
            }
        ]
        return rules
    
    def slice_description_rules(self):
        rules = [
            {
                'role': 'system',
                'content': dedent(config.slice_description_template)
            },
            {
                'role': 'assistant',
                'content': 'Ok, I am your assistant. Now please show me the json form.'
            }
        ]
        return rules

    def check_tags_rules(self):
        rules = [
            {
                'role': 'system',
                'content': dedent(config.check_tags_template)
            },
            {
                'role': 'assistant',
                'content': 'Ok, I am your assistant. Now please show me the json form.'
            }
        ]
        return rules
    
    def predict_bg_errors_rules(self):
        rules = [
            {
                'role': 'system',
                'content': dedent(config.predict_bg_errors_template)
            },
            {
                'role': 'assistant',
                'content': 'Ok, I am your assistant. Now please show me the json form.'
            }
        ]
        return rules
    
    def predict_cls_errors_rules(self):
        rules = [
            {
                'role': 'system',
                'content': dedent(config.predict_cls_errors_template)
            },
            {
                'role': 'assistant',
                'content': 'Ok, I am your assistant. Now please show me the json form.'
            }
        ]
        return rules

    def predict_pose_errors_rules(self):
        rules = [
            {
                'role': 'system',
                'content': dedent(config.predict_pose_errors_template)
            },
            {
                'role': 'assistant',
                'content': 'Ok, I am your assistant. Now please show me the json form.'
            }
        ]
        return rules
    
    def predict_det_errors_rules(self):
        rules = [
            {
                'role': 'system',
                'content': dedent(config.predict_det_errors_template)
            },
            {
                'role': 'assistant',
                'content': 'Ok, I am your assistant. Now please show me the json form.'
            }
        ]
        return rules
    
    def extract_tags_question(self, form, cls):
        form = json.dumps(form)
        question = f"""
            The json form of visual attributes is {form}. The main object of the images is {cls}.
            Now please output the tags.
        """
        return question
    
    def check_tags_question(self, form, cls):
        form = json.dumps(form)
        question = f"""
            The json form of visual attributes and tags is {form}.
            The main object of the images is {cls}.
            Now please output the corrected form.
        """
        return question

    def label_data_stage1_question(self, form, cls):
        form = json.dumps(form)
        question = f"""
            The json form of visual attributes and tags is {form}.
            The main object of the image is {cls}.
            Now please output form.
        """
        return question
    
    def label_data_stage2_question(self, form, cls):
        form = json.dumps(form)
        question = f"""
            The json form of tags is {form}.
            The main object of the image is {cls}.
            Now please output form.
        """
        return question
    
    def label_data_stage3_question(self, form, cls):
        form = json.dumps(form)
        question = f"""
            The json form of visual attributes and tags is {form}.
            The main object of the image is {cls}.
            Now please output form.
        """
        return question
    
    def tag_description_question(self, form, cls):
        form = json.dumps(form)
        question = f"""
            The json form of visual attributes and tags is {form}.
            The main object of the image is {cls}.
            Now please output form.
        """
        return question

    def slice_description_question(self, form, cls):
        form = json.dumps(form)
        question = f"""
            The JSON dictionary is {form}.
            The main object of the image is {cls}.
            Now please output form.
        """
        return question
    
    def slice_description_question(self, form, cls):
        form = json.dumps(form)
        question = f"""
            The json form of visual attributes and tags is {form}.
            The main object of the image is {cls}.
            Now please output form.
        """
        return question
    
    def estimate_question(self, description):
        question = f"""
            Please examine the image below and determine if it matches the following description:
            {description}
            Respond with 'True' if the image matches the description, or 'False' if it does not."""
        return question
    
    def predict_bg_errors_question(self, cls, tags, combination_size):
        question = f"""
            The main object of the image is {cls}.
            The json form of visual attributes is {json.dumps(tags)},
            and the number of attribute-tag pairs in each predicted combination is {combination_size}.
            Now please output the predicted form of attribute-tag combinations."""
        return question
    
    def predict_cls_errors_question(self, cls1, cls2, tags, combination_size):
        question = f"""
            The main object of the image is {cls1}. The confused class is {cls2}
            The json form of visual attributes is {json.dumps(tags)},
            and the number of attribute-tag pairs in each predicted combination is {combination_size}.
            Now please output the predicted form of attribute-tag combinations. You should output 20 combinations."""
        return question
    
    def predict_pose_errors_question(self, cls1, tags, combination_size):
        question = f"""
            The main object of the image is {cls1}.
            The json form of visual attributes is {json.dumps(tags)},
            and the number of attribute-tag pairs in each predicted combination is {combination_size}.
            Now please output the predicted form of attribute-tag combinations. You should output 20 combinations."""
        return question
    
    def predict_det_errors_question(self, cls1, tags, combination_size):
        question = f"""
            The main object of the image is {cls1}.
            The json form of visual attributes is {json.dumps(tags)},
            and the number of attribute-tag pairs in each predicted combination is {combination_size}.
            Now please output the predicted form of attribute-tag combinations. You should output 20 combinations."""
        return question
    
    def init_attrs_question(self, cls):
        question = f"""
            The main objects is  {cls}.
            Now please output the form.
        """
        return question
    
    def extract_dataset_attrs_question(self, form=None, category='person'):
        if form is None:
            form = json.dumps({
                'main object': [],
                'background': [],
                'global': []
            })
        question = f"""
            The json form of visual attributes is {form}.
            The main objects is  {category}.
            Now please output the new form.
        """
        return question
    
    def extract_clf_attrs_question(self, cls1, cls2):
        question = f"""
            The name of the main object class is {cls1}. The name of the second clas is {cls2}.
            Now please output the form.
        """
        return question
    
    def extract_pose_attrs_question(self, cls):
        question = f"""
            The name of the main object is {cls}. 
            Now please output the form.
        """
        return question
    
    def extract_det_attrs_question(self, cls):
        question = f"""
            The name of the main object is {cls}. 
            Now please output the form.
        """
        return question
    
    def check_attrs_question(self, form, cls):
        form = json.dumps(form)
        question = f"""
            The json form of visual attributes is {form}.
            The main objects is {cls}.
            Now please output the corrected form.
        """
        return question
    
    def check_label_question(self, tags, labels, cls):
        question = f"""
            The main object is {cls}.
            The tag form is {json.dumps(tags)}
            The label form is {json.dumps(labels)}.
            Now please output the corrected form.
        """
        return question
