from analyse.enumeration import fast_enumeration, baseline_enumeration
import json
import pickle

tags_refined_file = 'outputs/classification/bear_tags_refined.json'
label_file = 'outputs/classification/bear_labels.pkl'

with open(tags_refined_file, 'r') as f:
    tags = json.load(f)
with open(label_file, 'rb') as f:
    labels = pickle.load(f)

state_results = fast_enumeration(tags, labels, maximum_depth=4, valueable_size=10)
state_results = baseline_enumeration(tags, labels, maximum_depth=4, valueable_size=10)
