import pickle
from analyse.unseen_slice import error_slices_variate, error_slices_predict
import json
from prompts.debug import Prompts
from utils.gpt import Debug_with_GPT4V
from api_key import api_key, base_url

# tag subsititusion
stat_file = "./outputs/classification/resnet_visual.pkl"
with open(stat_file, 'rb') as file:
    stat = pickle.load(file)
tag_features_file = "./outputs/classification/bear_tag_features.pkl"
with open(tag_features_file, 'rb') as file:
    tags_features = pickle.load(file)
tag_file = "./outputs/classification/bear_tags_refined.json"
with open(tag_file, 'r') as file:
    tags = json.load(file)
predicted_slices = error_slices_variate(stat, tags_features)
with open("./outputs/classification/slice_variate.json", 'w') as file:
    file.write(json.dumps(predicted_slices, indent=4))

# gpt predict
debug_agent = Debug_with_GPT4V(api_key, base_url)
prompt_agent = Prompts()
predict_results = error_slices_predict(prompt_agent, debug_agent, tags, 3, task="cls")
with open("./outputs/classification/slice_predicted.json", 'w') as f:
    json.dump(predict_results, f, indent=4)