from dotenv import load_dotenv
import logging
import os

from langchain_openai import ChatOpenAI

from src.llm.base_llm import BaseLLM
from src.prompt.prompt import BasePrompt


class GPTMini(BaseLLM):
    name = "GPT-mini"

    def __init__(self, prompt: BasePrompt | None, temperature: float = 1, logprobs: bool = False):
        load_dotenv()
        self.temperature = temperature
        self.api_key = os.getenv("OPENAI_API_KEY")
        model = ChatOpenAI(openai_api_key=self.api_key, model="gpt-4o-mini-2024-07-18", temperature=self.temperature, request_timeout=60)
        if logprobs:
            model = model.bind(logprobs=True)

        super().__init__(model, prompt)

    def update_temperature(self, temperature):
        self.temperature = temperature
        self.model = ChatOpenAI(openai_api_key=self.api_key, model="gpt-4o-mini-2024-07-18", temperature=self.temperature, request_timeout=60)


class GPT4o(BaseLLM):
    name = "GPT-4o_240806"

    def __init__(self, prompt: BasePrompt | None, temperature: float = 1, logprobs: bool = False):
        load_dotenv()
        self.temperature = temperature
        self.api_key = os.getenv("OPENAI_API_KEY")
        model = ChatOpenAI(openai_api_key=self.api_key, model="gpt-4o-2024-08-06", temperature=self.temperature, request_timeout=60)
        if logprobs:
            model = model.bind(logprobs=True)
        super().__init__(model, prompt)

    def update_temperature(self, temperature):
        self.temperature = temperature
        self.model = ChatOpenAI(openai_api_key=self.api_key, model="gpt-4o-2024-08-06", temperature=self.temperature, request_timeout=60)