from abc import ABC
import logging
import os
import coloredlogs
from datetime import datetime


class BaseLogger(ABC):
    def __init__(self, log_level: str = logging.DEBUG):
        # log setting
        self.logger = logging.getLogger(self.__class__.__qualname__)
        coloredlogs.install(
            fmt="%(asctime)s %(name)s[%(process)d] %(levelname)s %(message)s", level='DEBUG', logger=self.logger)

        if not os.path.exists('./logs'):
            os.makedirs('./logs')

        # Set the log level
        self.log_level = log_level
        self.logger.setLevel(self.log_level)
