from collections.abc import Iterable
import warnings


def fixed_value(left, right):
    return right if right else left


def update_list(left: list | None, right: list | None) -> list:
    if (len(left) != 1 and len(right) != 1) and left == right:
        return right
    if not left:
        left = []
    if not right:
        right = []
    return left + right


def update_dict(left: dict | None, right: dict | None) -> dict:
    if not left:
        left = {}
    if not right:
        right = {}
    return {**left, **right}


def unlist_state(state: dict):
    new_state = {}
    for k, v in state.items():
        if isinstance(v, list):
            for i, item in enumerate(v):
                new_state[f"{k}[{i}]"] = item
        new_state[k] = v
    return new_state
