from langsmith import Client
from langsmith.evaluation import evaluate
from uuid import uuid4
from src.graph.sorting_graph import sorting_graph


def gen_predict(graph):
    def predict(inputs: dict):
        res = graph.invoke(inputs)
        return res
    return graph, predict


if __name__ == "__main__":
    run_id = uuid4()

    graph = sorting_graph().with_config(recursion_limit=75)

    client = Client()

    dataset_name = "sorting_256"
    datasets = client.list_datasets()

    dataset_id = [dataset.id for dataset in datasets if dataset.name == dataset_name][0]
    predict = gen_predict(graph)

    res = evaluate(
        predict[1],
        data=dataset_name,
        max_concurrency=1,
        experiment_prefix=predict[0].name,
        metadata={
            "run_id": run_id,
            "version": "1.0.0",
            "variant": "runnable",
        },
    )
