import os

from langchain_core.pydantic_v1 import BaseModel, Field

from src.prompt.prompt import BasePrompt


class MethodModel(BaseModel):
    method: str = Field(description="How to sort the numbers.")
    evaluate_methods: list[str] = Field(description="Methods to evaluate the sorted numbers.")


class MethodPrompt(BasePrompt):
    def __init__(self):
        super().__init__(MethodModel, human_template_file="human/sorting_method_prompt.txt",
                         system_template_file="system/sorting_method_system.txt")


class SortingModel(BaseModel):
    answer_rationale: str = Field(description="Answer the rationale for the sorted numbers.")
    answer: list = Field(description="Answer the sorted numbers.")


class SortingPrompt(BasePrompt):
    def __init__(self):
        super().__init__(SortingModel, human_template_file="human/sorting_prompt.jinja2",
                         system_template_file="system/sorting_system.txt", is_jinja=True)


class GetRationaleProbModel(BaseModel):
    accuracy: int = Field(description="Answer the sorted result accuracy between 0 to 100.")
    accuracy_rationale: str = Field(description="Answer the rationale for the accuracy.")


class GetRationaleProbPrompt(BasePrompt):
    def __init__(self):
        super().__init__(GetRationaleProbModel, human_template_file="human/sorting_prob_prompt.jinja2",
                         system_template_file="system/sorting_prob_system.txt", is_jinja=True)


class AggregateRationaleModel(BaseModel):
    aggregate_rationale: str = Field(description="Answer the aggregate rationales.")
    inaccurate_info: str = Field(description="Answer the inaccurate information about numbers.")


class AggregateRationalePrompt(BasePrompt):
    def __init__(self):
        super().__init__(AggregateRationaleModel, human_template_file="human/sorting_aggregate_rationale_prompt.jinja2",
                         system_template_file="system/sorting_aggregate_rationale_system.txt", is_jinja=True)
