import re

import json

import re
from mathruler.grader import grade_answer
from math_verify import verify, parse
from typing import Optional
from math_verify.errors import TimeoutException
from math_verify.metric import math_metric
from math_verify import parse, verify
from mathruler.grader import extract_boxed_content, grade_answer
from custom_reward_score.math_utils import is_equiv,latex_equal

def r1v_format_reward(predict_str: str, is_pra = True) -> float:
    special = not predict_str.lstrip().startswith("<think>")
    pattern = re.compile(r"^<think>.*</think>.*\\boxed\{.*\}.*", re.DOTALL)
    format_match = re.fullmatch(pattern, predict_str)
    reward = 1.0 if format_match else 0.0
    return reward, special

def find_answer(predict_str: str):
    # print('predict_str',predict_str)
    content_match = re.search(r"<answer>(.*?)</answer>", predict_str)
    if content_match:
        answer = content_match.group(1) 
        return answer
    
    answer = extract_boxed_content(predict_str)
    # print(2,predict_str)
    # print(answer)
    if answer is None or answer == 'None':
        answer = predict_str.strip()
    # print('1',answer)
    return answer
    

def r1v_math_accuracy_reward(predict_str: str, ground_truth: str) -> float:
    # 先尝试提取 answer，如果失败直接返回 0
    ground_truth = str(ground_truth).strip()
    answer = find_answer(predict_str)
    # print(answer)
    # 把所有检查按顺序尝试，任意一个返回 True 就给 1.0
    try:
        if is_equiv(answer, ground_truth):
            return 1.0
    except Exception:
        pass

    try:
        if latex_equal(answer, ground_truth):
            return 1.0
    except Exception:
        pass

    try:
        if grade_answer(f"${answer}$", f"${ground_truth}$"):
            return 1.0
    except Exception:
        pass

    try:
        if grade_answer(answer, ground_truth):
            return 1.0
    except Exception:
        pass

    try:
        if verify(parse(f"${ground_truth}$"), parse(f"${answer}$")):
            return 1.0
    except Exception:
        pass

    try:
        if verify(parse(ground_truth), parse(answer)):
            return 1.0
    except Exception:
        pass
    # print(ground_truth)
    # print(parse(answer),parse(ground_truth))
    return 0.0


def math_compute_score(predict_str: str, ground_truth: str, is_pra = True) -> float:
    acc_score = r1v_math_accuracy_reward(predict_str, ground_truth)
    format_score,special_format = r1v_format_reward(predict_str, is_pra)
    score =  0.9 * acc_score + 0.1 * format_score
    return score, acc_score, format_score






TRACE_LIST=[
  "<global></global><focus></focus><hint></hint><focus></focus><hint></hint><answer></answer>",
  "<global></global><focus></focus><hint></hint><focus></focus><think></think><answer></answer>",
  "<global></global><focus></focus><hint></hint><focus></focus><answer></answer>",
  "<global></global><focus></focus><hint></hint><think></think><focus></focus><answer></answer>",
  "<global></global><focus></focus><hint></hint><think></think><hint></hint><answer></answer>",
  "<global></global><focus></focus><hint></hint><think></think><answer></answer>",
  "<global></global><focus></focus><hint></hint><answer></answer>",
  "<global></global><focus></focus><think></think><focus></focus><hint></hint><answer></answer>",
  "<global></global><focus></focus><think></think><focus></focus><think></think><answer></answer>",
  "<global></global><focus></focus><think></think><focus></focus><answer></answer>",
  "<global></global><focus></focus><think></think><hint></hint><focus></focus><answer></answer>",
  "<global></global><focus></focus><think></think><hint></hint><think></think><answer></answer>",
  "<global></global><focus></focus><think></think><hint></hint><answer></answer>",
  "<global></global><focus></focus><think></think><answer></answer>",
  "<global></global><focus></focus><answer></answer>",
  "<global></global><hint></hint><focus></focus><hint></hint><focus></focus><answer></answer>",
  "<global></global><hint></hint><focus></focus><hint></hint><think></think><answer></answer>",
  "<global></global><hint></hint><focus></focus><hint></hint><answer></answer>",
  "<global></global><hint></hint><focus></focus><think></think><focus></focus><answer></answer>",
  "<global></global><hint></hint><focus></focus><think></think><hint></hint><answer></answer>",
  "<global></global><hint></hint><focus></focus><think></think><answer></answer>",
  "<global></global><hint></hint><focus></focus><answer></answer>",
  "<global></global><hint></hint><think></think><focus></focus><hint></hint><answer></answer>",
  "<global></global><hint></hint><think></think><focus></focus><think></think><answer></answer>",
  "<global></global><hint></hint><think></think><focus></focus><answer></answer>",
  "<global></global><hint></hint><think></think><hint></hint><focus></focus><answer></answer>",
  "<global></global><hint></hint><think></think><hint></hint><think></think><answer></answer>",
  "<global></global><hint></hint><think></think><hint></hint><answer></answer>",
  "<global></global><hint></hint><think></think><answer></answer>",
  "<global></global><hint></hint><answer></answer>",
  "<global></global><think></think><focus></focus><hint></hint><focus></focus><answer></answer>",
  "<global></global><think></think><focus></focus><hint></hint><think></think><answer></answer>",
  "<global></global><think></think><focus></focus><hint></hint><answer></answer>",
  "<global></global><think></think><focus></focus><think></think><focus></focus><answer></answer>",
  "<global></global><think></think><focus></focus><think></think><hint></hint><answer></answer>",
  "<global></global><think></think><focus></focus><think></think><answer></answer>",
  "<global></global><think></think><focus></focus><answer></answer>",
  "<global></global><think></think><hint></hint><focus></focus><hint></hint><answer></answer>",
  "<global></global><think></think><hint></hint><focus></focus><think></think><answer></answer>",
  "<global></global><think></think><hint></hint><focus></focus><answer></answer>",
  "<global></global><think></think><hint></hint><think></think><focus></focus><answer></answer>",
  "<global></global><think></think><hint></hint><think></think><hint></hint><answer></answer>",
  "<global></global><think></think><hint></hint><think></think><answer></answer>",
  "<global></global><think></think><hint></hint><answer></answer>",
  "<global></global><think></think><answer></answer>",
  "<focus></focus><global></global><focus></focus><hint></hint><focus></focus><answer></answer>",
  "<focus></focus><global></global><focus></focus><hint></hint><think></think><answer></answer>",
  "<focus></focus><global></global><focus></focus><hint></hint><answer></answer>",
  "<focus></focus><global></global><focus></focus><think></think><focus></focus><answer></answer>",
  "<focus></focus><global></global><focus></focus><think></think><hint></hint><answer></answer>",
  "<focus></focus><global></global><focus></focus><think></think><answer></answer>",
  "<focus></focus><global></global><focus></focus><answer></answer>",
  "<focus></focus><global></global><hint></hint><focus></focus><hint></hint><answer></answer>",
  "<focus></focus><global></global><hint></hint><focus></focus><think></think><answer></answer>",
  "<focus></focus><global></global><hint></hint><focus></focus><answer></answer>",
  "<focus></focus><global></global><hint></hint><think></think><focus></focus><answer></answer>",
  "<focus></focus><global></global><hint></hint><think></think><hint></hint><answer></answer>",
  "<focus></focus><global></global><hint></hint><think></think><answer></answer>",
  "<focus></focus><global></global><hint></hint><answer></answer>",
  "<focus></focus><global></global><think></think><focus></focus><hint></hint><answer></answer>",
  "<focus></focus><global></global><think></think><focus></focus><think></think><answer></answer>",
  "<focus></focus><global></global><think></think><focus></focus><answer></answer>",
  "<focus></focus><global></global><think></think><hint></hint><focus></focus><answer></answer>",
  "<focus></focus><global></global><think></think><hint></hint><think></think><answer></answer>",
  "<focus></focus><global></global><think></think><hint></hint><answer></answer>",
  "<focus></focus><global></global><think></think><answer></answer>",
  "<focus></focus><hint></hint><focus></focus><hint></hint><focus></focus><answer></answer>",
  "<focus></focus><hint></hint><focus></focus><hint></hint><think></think><answer></answer>",
  "<focus></focus><hint></hint><focus></focus><hint></hint><answer></answer>",
  "<focus></focus><hint></hint><focus></focus><think></think><focus></focus><answer></answer>",
  "<focus></focus><hint></hint><focus></focus><think></think><hint></hint><answer></answer>",
  "<focus></focus><hint></hint><focus></focus><think></think><answer></answer>",
  "<focus></focus><hint></hint><focus></focus><answer></answer>",
  "<focus></focus><hint></hint><think></think><focus></focus><hint></hint><answer></answer>",
  "<focus></focus><hint></hint><think></think><focus></focus><think></think><answer></answer>",
  "<focus></focus><hint></hint><think></think><focus></focus><answer></answer>",
  "<focus></focus><hint></hint><think></think><hint></hint><focus></focus><answer></answer>",
  "<focus></focus><hint></hint><think></think><hint></hint><think></think><answer></answer>",
  "<focus></focus><hint></hint><think></think><hint></hint><answer></answer>",
  "<focus></focus><hint></hint><think></think><answer></answer>",
  "<focus></focus><hint></hint><answer></answer>",
  "<focus></focus><think></think><focus></focus><hint></hint><focus></focus><answer></answer>",
  "<focus></focus><think></think><focus></focus><hint></hint><think></think><answer></answer>",
  "<focus></focus><think></think><focus></focus><hint></hint><answer></answer>",
  "<focus></focus><think></think><focus></focus><think></think><focus></focus><answer></answer>",
  "<focus></focus><think></think><focus></focus><think></think><hint></hint><answer></answer>",
  "<focus></focus><think></think><focus></focus><think></think><answer></answer>",
  "<focus></focus><think></think><focus></focus><answer></answer>",
  "<focus></focus><think></think><hint></hint><focus></focus><hint></hint><answer></answer>",
  "<focus></focus><think></think><hint></hint><focus></focus><think></think><answer></answer>",
  "<focus></focus><think></think><hint></hint><focus></focus><answer></answer>",
  "<focus></focus><think></think><hint></hint><think></think><focus></focus><answer></answer>",
  "<focus></focus><think></think><hint></hint><think></think><hint></hint><answer></answer>",
  "<focus></focus><think></think><hint></hint><think></think><answer></answer>",
  "<focus></focus><think></think><hint></hint><answer></answer>",
  "<focus></focus><think></think><answer></answer>",
  "<focus></focus><answer></answer>",
  "<hint></hint><focus></focus><hint></hint><focus></focus><hint></hint><answer></answer>",
  "<hint></hint><focus></focus><hint></hint><focus></focus><think></think><answer></answer>",
  "<hint></hint><focus></focus><hint></hint><focus></focus><answer></answer>",
  "<hint></hint><focus></focus><hint></hint><think></think><focus></focus><answer></answer>",
  "<hint></hint><focus></focus><hint></hint><think></think><hint></hint><answer></answer>",
  "<hint></hint><focus></focus><hint></hint><think></think><answer></answer>",
  "<hint></hint><focus></focus><hint></hint><answer></answer>",
  "<hint></hint><focus></focus><think></think><focus></focus><hint></hint><answer></answer>",
  "<hint></hint><focus></focus><think></think><focus></focus><think></think><answer></answer>",
  "<hint></hint><focus></focus><think></think><focus></focus><answer></answer>",
  "<hint></hint><focus></focus><think></think><hint></hint><focus></focus><answer></answer>",
  "<hint></hint><focus></focus><think></think><hint></hint><think></think><answer></answer>",
  "<hint></hint><focus></focus><think></think><hint></hint><answer></answer>",
  "<hint></hint><focus></focus><think></think><answer></answer>",
  "<hint></hint><focus></focus><answer></answer>",
  "<hint></hint><global></global><focus></focus><hint></hint><focus></focus><answer></answer>",
  "<hint></hint><global></global><focus></focus><hint></hint><think></think><answer></answer>",
  "<hint></hint><global></global><focus></focus><hint></hint><answer></answer>",
  "<hint></hint><global></global><focus></focus><think></think><focus></focus><answer></answer>",
  "<hint></hint><global></global><focus></focus><think></think><hint></hint><answer></answer>",
  "<hint></hint><global></global><focus></focus><think></think><answer></answer>",
  "<hint></hint><global></global><focus></focus><answer></answer>",
  "<hint></hint><global></global><hint></hint><focus></focus><hint></hint><answer></answer>",
  "<hint></hint><global></global><hint></hint><focus></focus><think></think><answer></answer>",
  "<hint></hint><global></global><hint></hint><focus></focus><answer></answer>",
  "<hint></hint><global></global><hint></hint><think></think><focus></focus><answer></answer>",
  "<hint></hint><global></global><hint></hint><think></think><hint></hint><answer></answer>",
  "<hint></hint><global></global><hint></hint><think></think><answer></answer>",
  "<hint></hint><global></global><hint></hint><answer></answer>",
  "<hint></hint><global></global><think></think><focus></focus><hint></hint><answer></answer>",
  "<hint></hint><global></global><think></think><focus></focus><think></think><answer></answer>",
  "<hint></hint><global></global><think></think><focus></focus><answer></answer>",
  "<hint></hint><global></global><think></think><hint></hint><focus></focus><answer></answer>",
  "<hint></hint><global></global><think></think><hint></hint><think></think><answer></answer>",
  "<hint></hint><global></global><think></think><hint></hint><answer></answer>",
  "<hint></hint><global></global><think></think><answer></answer>",
  "<hint></hint><think></think><focus></focus><hint></hint><focus></focus><answer></answer>",
  "<hint></hint><think></think><focus></focus><hint></hint><think></think><answer></answer>",
  "<hint></hint><think></think><focus></focus><hint></hint><answer></answer>",
  "<hint></hint><think></think><focus></focus><think></think><focus></focus><answer></answer>",
  "<hint></hint><think></think><focus></focus><think></think><hint></hint><answer></answer>",
  "<hint></hint><think></think><focus></focus><think></think><answer></answer>",
  "<hint></hint><think></think><focus></focus><answer></answer>",
  "<hint></hint><think></think><hint></hint><focus></focus><hint></hint><answer></answer>",
  "<hint></hint><think></think><hint></hint><focus></focus><think></think><answer></answer>",
  "<hint></hint><think></think><hint></hint><focus></focus><answer></answer>",
  "<hint></hint><think></think><hint></hint><think></think><focus></focus><answer></answer>",
  "<hint></hint><think></think><hint></hint><think></think><hint></hint><answer></answer>",
  "<hint></hint><think></think><hint></hint><think></think><answer></answer>",
  "<hint></hint><think></think><hint></hint><answer></answer>",
  "<hint></hint><think></think><answer></answer>",
  "<hint></hint><answer></answer>",
  "<think></think><focus></focus><hint></hint><focus></focus><hint></hint><answer></answer>",
  "<think></think><focus></focus><hint></hint><focus></focus><think></think><answer></answer>",
  "<think></think><focus></focus><hint></hint><focus></focus><answer></answer>",
  "<think></think><focus></focus><hint></hint><think></think><focus></focus><answer></answer>",
  "<think></think><focus></focus><hint></hint><think></think><hint></hint><answer></answer>",
  "<think></think><focus></focus><hint></hint><think></think><answer></answer>",
  "<think></think><focus></focus><hint></hint><answer></answer>",
  "<think></think><focus></focus><think></think><focus></focus><hint></hint><answer></answer>",
  "<think></think><focus></focus><think></think><focus></focus><think></think><answer></answer>",
  "<think></think><focus></focus><think></think><focus></focus><answer></answer>",
  "<think></think><focus></focus><think></think><hint></hint><focus></focus><answer></answer>",
  "<think></think><focus></focus><think></think><hint></hint><think></think><answer></answer>",
  "<think></think><focus></focus><think></think><hint></hint><answer></answer>",
  "<think></think><focus></focus><think></think><answer></answer>",
  "<think></think><focus></focus><answer></answer>",
  "<think></think><hint></hint><focus></focus><hint></hint><focus></focus><answer></answer>",
  "<think></think><hint></hint><focus></focus><hint></hint><think></think><answer></answer>",
  "<think></think><hint></hint><focus></focus><hint></hint><answer></answer>",
  "<think></think><hint></hint><focus></focus><think></think><focus></focus><answer></answer>",
  "<think></think><hint></hint><focus></focus><think></think><hint></hint><answer></answer>",
  "<think></think><hint></hint><focus></focus><think></think><answer></answer>",
  "<think></think><hint></hint><focus></focus><answer></answer>",
  "<think></think><hint></hint><think></think><focus></focus><hint></hint><answer></answer>",
  "<think></think><hint></hint><think></think><focus></focus><think></think><answer></answer>",
  "<think></think><hint></hint><think></think><focus></focus><answer></answer>",
  "<think></think><hint></hint><think></think><hint></hint><focus></focus><answer></answer>",
  "<think></think><hint></hint><think></think><hint></hint><think></think><answer></answer>",
  "<think></think><hint></hint><think></think><hint></hint><answer></answer>",
  "<think></think><hint></hint><think></think><answer></answer>",
  "<think></think><hint></hint><answer></answer>",
  "<think></think><global></global><focus></focus><hint></hint><focus></focus><answer></answer>",
  "<think></think><global></global><focus></focus><hint></hint><think></think><answer></answer>",
  "<think></think><global></global><focus></focus><hint></hint><answer></answer>",
  "<think></think><global></global><focus></focus><think></think><focus></focus><answer></answer>",
  "<think></think><global></global><focus></focus><think></think><hint></hint><answer></answer>",
  "<think></think><global></global><focus></focus><think></think><answer></answer>",
  "<think></think><global></global><focus></focus><answer></answer>",
  "<think></think><global></global><hint></hint><focus></focus><hint></hint><answer></answer>",
  "<think></think><global></global><hint></hint><focus></focus><think></think><answer></answer>",
  "<think></think><global></global><hint></hint><focus></focus><answer></answer>",
  "<think></think><global></global><hint></hint><think></think><focus></focus><answer></answer>",
  "<think></think><global></global><hint></hint><think></think><hint></hint><answer></answer>",
  "<think></think><global></global><hint></hint><think></think><answer></answer>",
  "<think></think><global></global><hint></hint><answer></answer>",
  "<think></think><global></global><think></think><focus></focus><hint></hint><answer></answer>",
  "<think></think><global></global><think></think><focus></focus><think></think><answer></answer>",
  "<think></think><global></global><think></think><focus></focus><answer></answer>",
  "<think></think><global></global><think></think><hint></hint><focus></focus><answer></answer>",
  "<think></think><global></global><think></think><hint></hint><think></think><answer></answer>",
  "<think></think><global></global><think></think><hint></hint><answer></answer>",
  "<think></think><global></global><think></think><answer></answer>",
  "<think></think><answer></answer>"
]

def extract_trajectory(model_output):
    # 定义目标标签列表
    target_tags = ['global', 'hint', 'think', 'answer', 'focus']

    # 构造正则表达式模式，匹配目标标签及其内容
    pattern = re.compile(
        r'<(' + '|'.join(target_tags) + r')(\b[^>]*)>(.*?)</\1>',
        re.DOTALL | re.IGNORECASE
    )

    # 存储提取的空标签
    empty_tags = []

    # 查找所有匹配项
    for match in pattern.finditer(model_output):
        tag_name = match.group(1)  # 标签名
        attributes = match.group(2)  # 标签属性（如果有）
        # 构造空标签对（保留属性）
        empty_tag = f"<{tag_name}{attributes}></{tag_name}>"
        empty_tags.append(empty_tag)
    action_num = ''.join(empty_tags).count('<')/2
    # 按原顺序拼接结果
    return ''.join(empty_tags),action_num


def r1v_format_reward(predict_str: str, is_pra = True) -> float:
    if is_pra:
        pattern = re.compile(r"^<think>.*?</think>\s*<answer>.*?</answer>$", re.DOTALL)
    else:
        pattern = re.compile(r"^<answer>.*?</answer>\s*<think>.*?</think>$", re.DOTALL)
    format_match = re.fullmatch(pattern, predict_str)
    return 1.0 if format_match else 0.0

def r1v_accuracy_reward(predict_str: str, ground_truth: str) -> float:
    try:
        try:
            if r1v_math_accuracy_reward(predict_str, ground_truth) == 1.0:
                return 1.0
        except Exception:
            pass
    
        ground_truth = ground_truth.strip()
        content_match = re.search(r"<answer>(.*?)</answer>", predict_str)
        given_answer = content_match.group(1) if content_match else predict_str
        given_answer = given_answer.strip()
        if "<answer>" in ground_truth:
            ground_truth = re.search(r"<answer>(.*?)</answer>", ground_truth).group(1).strip()
        if given_answer == ground_truth:
            return 1.0
        # elif ground_truth in given_answer:
        #     return 1.0

            
    except Exception:
        pass

    return 0.0


def compute_score(
    data_source,
    solution_str,
    ground_truth,
    extra_info,
):
    # print(extra_info)
    is_single_image = extra_info.get('is_single_image',False)

    traj,action_num = extract_trajectory(solution_str)
    
    if is_single_image:
        if traj in TRACE_LIST and 'global' not in traj:
            #format_score = 1*action_num/6
            format_score = 1
        else:
            format_score = 0
    else:
        if traj in TRACE_LIST and 'global' in traj:
            #format_score = 1*action_num/6
            format_score = 1
        else:
            format_score = 0

    # print(format_score)
    if '°' in ground_truth:
        ground_truth = ground_truth.replace('°','')

    acc_score = r1v_accuracy_reward(solution_str, ground_truth)
    #format_score = r1v_format_reward(solution_str, True)
    score =  0.5 * acc_score + 0.5 * format_score
    return {
    "score": score,
    "acc": acc_score,
    "format": format_score,
    "traj":traj
    }



    # solution_str = solution_str[-300:]  # The longest answer in MATH-500 has 159 characters

    # # Verify the solution
    # correct, pred = verify(solution_str, ground_truth, strict_box_verify, pause_tokens_index)

    # reward = 1.0 if correct else -1.0
    # acc = correct

    # return {
    #     "score": reward,
    #     "acc": acc,
    #     "pred": pred,
    # }

# print(compute_score(1,"70",'Angle 4 measures 70 degrees because 180 - 110 = 70.',{'is_single_image':True}))

# print(r1v_math_accuracy_reward('70', '70^\\circ'))

# print(r1v_math_accuracy_reward('(1,2)', '1 < x < 2'))