# Copyright 2024 Bytedance Ltd. and/or its affiliates
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

import re

from mathruler.grader import grade_answer


def r1v_format_reward(predict_str: str, is_pra = True) -> float:
    if is_pra:
        pattern = re.compile(r"^<think>.*?</think>\s*<answer>.*?</answer>$", re.DOTALL)
    else:
        pattern = re.compile(r"^<answer>.*?</answer>\s*<think>.*?</think>$", re.DOTALL)
    format_match = re.fullmatch(pattern, predict_str)
    return 1.0 if format_match else 0.0

def r1v_accuracy_reward(predict_str: str, ground_truth: str) -> float:
    try:
        ground_truth = ground_truth.strip()
        content_match = re.search(r"<answer>(.*?)</answer>", predict_str)
        given_answer = content_match.group(1) if content_match else predict_str
        if "<answer>" in ground_truth:
            ground_truth = re.search(r"<answer>(.*?)</answer>", ground_truth).group(1).strip()
        if given_answer == ground_truth:
            return 1.0
    except Exception:
        pass

    return 0.0


from custom_reward_score.multi_image_reward import compute_score
    # data_source,
    # solution_str,
    # ground_truth,
    # extra_info,
def r1v_compute_score(predict_str: str, ground_truth: str, is_single_image = True) -> float:

    res = compute_score(data_source='v1',solution_str = predict_str,ground_truth = ground_truth ,extra_info={'is_single_image':is_single_image})
    score = res['score']
    acc_score = res['acc']
    format_score = res['format']
    traj = res['traj']
    return score, acc_score, format_score, traj

    # acc_score = r1v_accuracy_reward(predict_str, ground_truth)
    # format_score = r1v_format_reward(predict_str, is_pra)
    # score =  0.5 * acc_score + 0.5 * format_score
    # return 


# def r1v_compute_score(predict_str: str, ground_truth: str, is_pra = True) -> float:
#     acc_score = r1v_accuracy_reward(predict_str, ground_truth)
#     format_score = r1v_format_reward(predict_str, is_pra)
#     score =  0.5 * acc_score + 0.5 * format_score
#     return score, acc_score, format_score
