# Thresholding Strategies for Neural Network Runtime Monitoring

This zip folder serves as source code associated with the paper.
## Install

The installation proposed here is based on conda. The installation of conda is proposed on its official website.

If you have conda installed, you simply need to:
* Unzip the folder
* Install all dependencies in a conda virtual environment

        $ conda env create -f env.yml
* Activate the environment

        $ conda activate thresholding-runtime-monitor
* Change directory to the working folder (neural_network_monitoring/)
* Open jupyter notebook and open main notebook (indicated below)

## Background-related code

Before going into the experiments, preparatory code about access to available datasets, feature extractor, monitoring techniques as well as evaluation of monitor are given in these code files (monitor.py, dataset.py, feature_extractor.py, evaluation.py) and folders (Params, models). The code for the experiments proposed in the paper is put into the subfolder monitor_thresholding_strategies.


<details>
<summary><b>Dataset</b></summary>
This class allows to load a specific dataset. 

A dataset is configured by specifying 
* the **name** of the dataset, 
* the **split** (train/test),
* the **network** that will be used to process it, 
* the **additional transform**  applied to images (e.g., brightness changes), 
* the **adversarial attack** type applied to images, 
* and the **batch size**.

The valid configuration parameters are defined in *Params/params_dataset.py*.

See *dataset.py* for a more detailed documentation.
</details>

<details>
<summary><b>FeatureExtractor</b></summary>

This class aims to extract features and additional information associated to a set of input images from the classifier network. The layer examined is indicated by an id number. The features extracted are then saved for further use.

</details> 

<details>
<summary><b>Monitor</b></summary>
We define classes for each monitoring approach, by proposing fitting and predicting method as well as its parameter by default.
</details>

<details>
<summary><b>Evaluator</b></summary>

This class gives label of runtime monitor to input data knowing its classifier prediction score, and calls to different functions to evaluate different metrics on a set of data knowing then the monitor label. 

</details>

## Main-task code

To conduct experiments proposed in the paper, you simply need to open the jupyter notebook named Thresholding_Exp_Notebook.ipynb (in the subfolder monitor_thresholding_strategies) and run cells inside. 

For more information of the experiments design and the objectives, please refer to the paper associated. 

In this subfolder monitor_thresholding_strategies, the results csv is already given inside the folder result_csv as well as the images for results analysis inside the folder image. There are two results csv files, denoted Result-Thresh-Opt_resampling and Result-Thresh-Opt, one is the results where we optimize F1 with applying oversampling and one without.

You can reproduce all results analysis by running the main notebook. If you want to reconduct the experiments, you can rename or delete the already-existed results csv and rerun the notebook. 