
%The main function. Want to solve min_x ||Ax-b||_p subject to constraints
%B'*x = d to a (1+eps) approximation.

% For notation: m is the dimension, n is the number of constraints
function [final,call]= Dual(eps,q,C,r,solver)
    p = q/(q-1);
    A = transpose(C);
    [n, m] = size(A);
    b = zeros(n,1);
    B = r;
    d = ones(1,1);
    if solver == 1
        [y, call] = IRLS(eps,p,B,d,A,b);
    else
        [y, call] = pNorm(eps,A,b,p,transpose(B),d);
    end
    z = A * y;
    x = dot(r, y) / norm(z,p)^p * (z.^(p-1));
    S = C*A;
    L = A / S;
    u = L * (r - C*x);
    final = x + u;
end