 
% This function creates the required matrices from the graphs generated by
% Mauricio Flores et al. We use their scripts which are in the folder
% CreateGraphInstances and use that data to create the matrices.

function [A,b,C,d,sizedata] = create_graph_matrices(n,p,k_neigh)
     dim = 10; 
     addpath('CreateGraphInstances/') 
     [X, Y, g, m] = data_dim_d(n, dim);
     [knn, wnn, k_neigh] = compute_knn_wnn([X; Y], n, m, k_neigh);
     wnn = wnn(1:n,:); knn = knn(1:n,:);
     
    %create list of edges
   [rknn,cknn] = size(knn);
    L = [];
    Wt = [];
    for i = 1:rknn
        for j = 1:cknn
            if knn(i,j)~=1 && knn(i,j)> i
                edge = [i knn(i,j)];
                weight = wnn(i,j);
                L = [L;edge];
                Wt = [Wt;weight];
            end
        end
    end
    
    %create the graph
    G = graph(L(:,1),L(:,2));
    B = incidence(G);
    Unwtd_A = transpose(B);
    s = size(Wt);
    sizedata = s(1);
    
    %creating matrices A,b,C,d
    A = spdiags(Wt.^(1/p),zeros(1,1),s(1),s(1))*B';
    b = sparse(-A(:,n+1:n+m)*g);
    A = sparse(A(:,1:n));
    C = zeros(n);
    d = zeros(n,1);
end
