clear;
eps = 1e-10;
trial = 5;
k=5;
max_node = 5;
for j=1:trial
  for u=1:k
      q = 1+(2*u-1)*0.1;
      for s=1:max_node
         n = 500*s;
         m = n-100;
         
         rng(j+1);
 
         C = rand(n,m);
         v =  rand(m,1);
         r = C*v;

         disp("pNorm");
         tic
         [x1, cnt1] = Dual(eps,q,C,r,0);
         t1 = toc;
         norm1 = norm(x1, q);
         vio1 = norm(C*x1-r, 2);

         P1 = [cnt1 t1 norm1 vio1];
         name = "_pNorm_" + string(q) + "_" + string(n) + "_" + string(m) + "_" + string(j);
         % save('newplots_icml/test_all_hard_lp_q'+name+'.txt', 'P1', '-ascii', '-tabs');

         disp("IRLS");
         tic
         [x2, cnt2] = Dual(eps,q,C,r,1);
         t2 = toc;
         norm2 = norm(x2, q);
         vio2 = norm(C*x2-r, 2);

         P2 = [cnt2 t2 norm2 vio2];
         name = "_IRLS_" + string(q) + "_" + string(n) + "_" + string(m) + "_" + string(j);
         % save('newplots_icml/test_all_hard_lp_q'+name+'.txt', 'P2', '-ascii', '-tabs');
        
        tic
        cvx_begin
        cvx_solver sedumi;
            variable x3(m);
            minimize( norm(x3,q) );
            subject to
                C*x3 == r;
        cvx_end
        t3 = toc;
        norm3 = norm(x3, q);
        cnt3 = cvx_slvitr;
        vio3 = norm(C*x3-r, 2);

        P3 = [cnt3 t3 norm3 vio3];
        name = "_cvx_sedumi_" + string(q) + "_" + string(n)+ "_" + string(m) + "_" + string(j);
        % save('newplots_icml/test_all_hard_lp_q'+name+'.txt', 'P3', '-ascii', '-tabs');
        
        tic
        cvx_begin
            variable x4(m);
            minimize( norm((x4),q) );
            subject to
                C*x4 == r;
        cvx_end
        t4 = toc;
        norm4 = norm(x4, q);
        cnt4 = cvx_slvitr;
        vio4 = norm(C*x4-r, 2);

        P4 = [cnt4 t4 norm4 vio4];
        name = "_cvx_" + string(q) + "_" + string(n)+ "_" + string(m) + "_" + string(j);
        % save('newplots_icml/test_all_hard_lp_q'+name+'.txt', 'P4', '-ascii', '-tabs');
      end
  end
end