 % We use the graph instances generate by Mauricio Flores et al. and run
 % our IRLS algorithm to find the minimum $\ell_p$ laplacian.
clear;
k = 8;
eps = 1e-10;
trial = 10;
nearest_neighbours = 10;
for j=1:trial
    
    n = 500;
    for i=1:k
        rng(j+3);
        p = i+2;
        disp(n);
        disp(p)


        [A,b,C,d,~] = create_graph_matrices(n,p,nearest_neighbours);
        B = transpose(C);
        disp("pNorm");
        tic
        [x1, cnt1] = pNorm(eps,A,b,p,C,d);
        t1 = toc
        norm1 = norm(A*x1-b, p)^p;
        vio1 = norm(C*x1-d, p);

        P = [cnt1 t1 norm1 vio1];
        name = "_pNorm_" + string(p) + "_" + string(n) + "_" + string(j)
        save('newplots_icml/test_all_lp_p'+name+'.txt', 'P', '-ascii', '-tabs');

        disp("IRLS");
        tic
        [x2, cnt2] = IRLS(eps,p,B,d,A,b);
        t2 = toc
        norm2 = norm(A*x2-b, p)^p;
        vio2 = norm(C*x2-d, p);

        P = [cnt2 t2 norm2 vio2];
        name = "_IRLS_" + string(p) + "_" + string(n) + "_" + string(j)
        save('newplots_icml/test_all_lp_p'+name+'.txt', 'P', '-ascii', '-tabs');

        tic
        cvx_begin
        cvx_solver sedumi;
            variable x3(n);
            minimize( norm((A*x3-b),p) );
            subject to
                C*x3 == d;
        cvx_end
        t3 = toc
        norm3 = norm(A*x3-b, p)^p;
        cnt3 = cvx_slvitr;
        vio3 = norm(C*x3-d, p);

        P = [cnt3 t3 norm3 vio3];
        name = "_cvx_sedumi_" + string(p) + "_" + string(n) + "_" + string(j)
        save('newplots_icml/test_all_lp_p'+name+'.txt', 'P', '-ascii', '-tabs');

        tic
        cvx_begin
            variable x4(n);
            minimize( norm((A*x4-b),p) );
            subject to
                C*x4 == d;
        cvx_end
        t4 = toc
        norm4 = norm(A*x4-b, p)^p;
        cnt4 = cvx_slvitr;
        vio4 = norm(C*x4-d, p);

        P = [cnt4 t4 norm4 vio4];
        name = "_cvx_" + string(p) + "_" + string(n) + "_" + string(j)
        save('newplots_icml/test_all_lp_p'+name+'.txt', 'P', '-ascii', '-tabs');
    end
end


 % We use the graph instances generate by Mauricio Flores et al. and run
 % our IRLS algorithm to find the minimum $\ell_p$ laplacian.
clear;
 k = 15;
 eps = 1e-10;
 trial = 5;
 max_node = 5;
 nearest_neighbours = 10;
 for j=1:trial
     for s=1:max_node
         n = 2000*s;
         for i=1:k
            rng(j+3);
             if i < 10
                 p = 2*i + 2;
             else
                 p = 5*(i-5);
             
             end
             disp(n);
             disp(p)
 
 
             [A,b,C,d,~] = create_graph_matrices(n,p,nearest_neighbours);
             B = transpose(C);
             disp("pNorm");
             tic
             [x1, cnt1] = pNorm(eps,A,b,p,C,d);
             t1 = toc
             norm1 = norm(A*x1-b, p)^p;
             vio1 = norm(C*x1-d, p);
 
             P = [cnt1 t1 norm1 vio1];
             name = "_pNorm_" + string(p) + "_" + string(n) + "_" + string(j)
             save('newplots_icml/test_all_large_lp_p'+name+'.txt', 'P', '-ascii', '-tabs');
 
             disp("IRLS");
             tic
             [x2, cnt2] = IRLS(eps,p,B,d,A,b);
             t2 = toc
             norm2 = norm(A*x2-b, p)^p;
             vio2 = norm(C*x2-d, p);
 
             P = [cnt2 t2 norm2 vio2];
             name = "_IRLS_" + string(p) + "_" + string(n) + "_" + string(j)
             save('newplots_icml/test_all_large_lp_p'+name+'.txt', 'P', '-ascii', '-tabs');
 
         end
     end
 end
 