 % We generate random matrices and run our IRLS algorithm on them. We will
 % set this up to run the algorithm for the unconstrained version.
 % Data dimensions are m x n, where n < m.
clear;
 k = 10;
 M = zeros(k,8);
 eps = 1e-10;
 p = 8;
 trial = 10;
 for j=1:trial
  
     for i=1:k
         disp(i);

         rng(j+3);
 
 
         n = 100*i;
          m = 50 + 100*(i-1);
 
         A = rand(n,m);
         b =  rand(n,1);
         
 
          C = zeros(m,m);
          d = zeros(m,1);
          B = transpose(C);
 
         disp("pNorm");
         tic
         [x1, cnt1] = pNorm(eps,A,b,p,C,d);
         t1 = toc
         norm1 = norm(A*x1-b, p)^p;
         vio1 = norm(C*x1-d, p);

         P = [cnt1 t1 norm1 vio1];
         name = "_pNorm_" + string(p) + "_" + string(n) + "_" + string(m) + "_" + string(j)
         save('newplots_icml/test_all_soft_lp_m'+name+'.txt', 'P', '-ascii', '-tabs');
 
         disp("IRLS");
         tic
         [x2, cnt2] = IRLS(eps,p,B,d,A,b);
         t2 = toc
         norm2 = norm(A*x2-b, p)^p;
         vio2 = norm(C*x2-d, p);

         P = [cnt2 t2 norm2 vio2];
         name = "_IRLS_" + string(p) + "_" + string(n) + "_" + string(m) + "_" + string(j)
         save('newplots_icml/test_all_soft_lp_m'+name+'.txt', 'P', '-ascii', '-tabs');
 
         tic
         cvx_begin
            cvx_solver sedumi;
             variable x3(m);
             minimize( norm((A*x3-b),p) );
         cvx_end
         t3 = toc
         norm3 = norm(A*x3-b, p)^p;
         cnt3 = cvx_slvitr;
         vio3 = norm(C*x3-d, p);

         P = [cnt3 t3 norm3 vio3];
         name = "_cvx_sedumi_" + string(p) + "_" + string(n)+ "_" + string(m) + "_" + string(j)
         save('newplots_icml/test_all_soft_lp_m'+name+'.txt', 'P', '-ascii', '-tabs');

         tic
         cvx_begin
             variable x4(m);
             minimize( norm((A*x4-b),p) );
         cvx_end
         t4 = toc
         norm4 = norm(A*x4-b, p)^p;
         cnt4 = cvx_slvitr;
         vio4 = norm(C*x4-d, p);

         P = [cnt4 t4 norm4 vio4];
         name = "_cvx_" + string(p) + "_" + string(n)+ "_" + string(m) + "_" + string(j)
         save('newplots_icml/test_all_soft_lp_m'+name+'.txt', 'P', '-ascii', '-tabs');
 
     end
 end

clear;

 k = 10;
 M = zeros(k,8);
 eps = 1e-10;
 p = 8;
 trial = 10;
 for j=1:trial
  
     for i=1:k
         disp(i);
         rng(j+3);
 
        s = 2*i+10
         n = 100*s;
          m = 50 + 100*(s-1);
 
         A = rand(n,m);
         b =  rand(n,1);
         
 
          C = zeros(m,m);
          d = zeros(m,1);
          B = transpose(C);
 
         disp("pNorm");
         tic
         [x1, cnt1] = pNorm(eps,A,b,p,C,d);
         t1 = toc
         norm1 = norm(A*x1-b, p)^p;
         vio1 = norm(C*x1-d, p);

         P = [cnt1 t1 norm1 vio1];
         name = "_pNorm_" + string(p) + "_" + string(n) + "_" + string(m) + "_" + string(j)
         save('newplots_icml/test_all_soft_lp_m'+name+'.txt', 'P', '-ascii', '-tabs');
 
         disp("IRLS");
         tic
         [x2, cnt2] = IRLS(eps,p,B,d,A,b);
         t2 = toc
         norm2 = norm(A*x2-b, p)^p;
         vio2 = norm(C*x2-d, p);

         P = [cnt2 t2 norm2 vio2];
         name = "_IRLS_" + string(p) + "_" + string(n) + "_" + string(m) + "_" + string(j)
         save('newplots_icml/test_all_soft_lp_m'+name+'.txt', 'P', '-ascii', '-tabs');
 
 
     end
 end