p = 8;
eps = 1e-10;


A = readmatrix("../slice_A.csv");
b = readmatrix("../slice_b.csv");
j = "song";

% disp(size(A));
% disp(size(b));
[n,m] = size(A);

C = zeros(m,m);
d = zeros(m,1);
B = transpose(C);

disp("pNorm");
tic
[x1, cnt1] = pNorm(eps,A,b,p,C,d);
t1 = toc;
norm1 = norm(A*x1-b, p)^p;
vio1 = norm(C*x1-d, p);

P = [cnt1 t1 norm1 vio1];

name = "_pNorm_" + string(p) + "_" + string(n) + "_" + string(m) + "_" + string(j);
save('newplots_icml/test_slice_lp_p'+name+'.txt', 'P', '-ascii', '-tabs');


disp(P);

disp("IRLS");
tic
[x2, cnt2] = IRLS(eps,p,B,d,A,b);
t2 = toc;
norm2 = norm(A*x2-b, p)^p;
vio2 = norm(C*x2-d, p);

P = [cnt2 t2 norm2 vio2];

name = "_IRLS_" + string(p) + "_" + string(n) + "_" + string(m) + "_" + string(j);
save('newplots_icml/test_slice_lp_p'+name+'.txt', 'P', '-ascii', '-tabs');
