"""Configuration dictionaries."""

from ml_collections import ConfigDict


def get_config():
  C = ConfigDict()

  # seed
  C.seed = 0

  # game
  C.dataset = 'random'  # 'random', 'ml-100k', 'lastfm-360k'
  C.dim = 10
  C.n_producers = 10
  C.n_consumers = 100
  C.nonnegative = False
  C.tau = 0.1  # temperature
  C.utility = 'exposure'

  # optimiser
  C.dynamics = 'simultaneous'

  C.lr = 1e-1
  C.tol = 1e-8
  C.regulariser = 0.0
  C.optimiser = 'optax'
  C.reparam = 'rescale'
  C.em = False
  C.n_inner_rounds = 1000
  C.n_outer_rounds = 10
  C.n_em_rounds = 10
  C.custom_grads = False
  C.scale_lr_by_temperature = False

  # logging and result saving
  C.output_dir = '../results/'
  C.output_name = ''
  C.try_seed_from_slurm = False
  C.log_loss = False
  C.log_optimal_strategies = False
  C.log_consumers = False
  C.disable_tqdm = True

  return C
