import os
import pickle
import numpy as np
from collections import defaultdict

np.random.seed(1024)

os.makedirs('./inventory', exist_ok=True)

n = 200000

# Feature construction
# Basically, there is no exact label but the demand itself induce the label (cost)

m = 100 # dimensionality
mean = 0 # mean
std = 0.1 # standard deviation

b = 0.3;

ite = 0;

while (True):
	print(ite)
	ite += 1
	# generate n vectors of m-dimensional independent and identically distributed Gaussian random variables
	X = np.random.normal(loc=mean, scale=std, size=(n, m))

	# True parameter \theta

	theta = np.random.normal(0, size = (m,1));

	eps = np.random.normal(0, 0.1, size = (n,1));

	d = 1/np.sqrt(m)*(X @ theta)+b+eps;
	d = (d-min(d))/(max(d)-min(d));

	result = (np.all(d>=0) and np.all(d<=1))
	if result:
		break;

tot = X.shape[0]

index = np.arange(tot)
np.random.shuffle(index)

data_info = {}
data_info['X'] = X
data_info['d'] = d
f = open('./inventory/data_inventory.gt', 'wb')
pickle.dump(data_info, f)

f = open('./inventory/data_inventory.gt', 'rb')
data = pickle.load(f)
X, d = data['X'], data['d']
label_count = np.sum(d, axis=0)
print(np.min(label_count), np.max(label_count))