import arff
import torch
import pickle
import numpy as np
import networkx as nx
import random
from networkx.algorithms.approximation import maximum_independent_set

def get_graph(graph_type, num_arms, edge_prob=0.5):
	graph = np.zeros((num_arms, num_arms))
	if graph_type == 'bandit':
		for i in range(num_arms):
			graph[i, i] = 1
	elif graph_type == 'inventory':
		for i in range(num_arms):
			for j in range(i, num_arms):
				graph[j, i] = 1
	elif graph_type == 'robs_cops':
		for i in range(num_arms):
			for j in range(num_arms):
				if (j != i):
					graph[i, j] = 1
	elif graph_type == 'full_info':
		for i in range(num_arms):
			for j in range(num_arms):
				graph[i, j] = 1
	elif graph_type == 'random':
		# Choose any number that you want
		seed = 314
		random.seed(seed)
		np.random.seed(seed)
		for i in range(num_arms):
			for j in range(num_arms):
				if (j == i):
					graph[i, j] = 1
				else:
					rand_num = random.random()
					if (rand_num > edge_prob):
						graph[i, j] = 1
	else:
		raise ValueError
	return graph

def normalization(X):
	# compute the mean and standard deviation of each feature
	mean = np.mean(X, axis=0)
	std = np.std(X, axis=0)

	# normalize the data by subtracting the mean and dividing by the standard deviation
	normalized_X = (X - mean) / std
	return normalized_X

def calc_ind(graph):
	k = graph.shape[0]
	g = nx.Graph()
	g.add_nodes_from(range(k))
	g.remove_edges_from(nx.selfloop_edges(g))
	for i in range(k):
		for j in range(k):
			if graph[i, j] > 0:
				g.add_edge(i, j)

	ind_set = maximum_independent_set(g)
	return ind_set

def load_inventory(file_path='./inventory/data_inventory.gt'):
	f = open(file_path, 'rb')
	data = pickle.load(f)
	X, y = data['X'].astype(np.float32), data['d'].astype(np.float32)
	return X, y

