# Graph Concept Bottleneck

This repository contains the official implementation of the paper:
**"Learning Language-grounded Concepts for Self-explainable Graph Neural Networks"**
Submitted to **ICLR 2026**.

---

## 📦 Requirements

This code has been successfully tested with the following environment:

* Python           == 3.10.14
* PyTorch          == 2.6.0+cu124
* NumPy            == 1.26.4
* scikit-learn     == 1.6.1
* transformers     == 4.49.0
* torch-geometric  == 2.6.1


> 🔧 **Working directory** is assumed to be the root of this repository (`./`).

---

## 🚀 Running the Code

### 🔹 Regular Setting

```bash
python train_GCB.py --dataset cora
```

### 🔸 OOD Setting

```bash
python train_GCB.py --dataset cora --up_ratio 5
```

### 🔺 Adversarial Setting

```bash
python train_GCB.py --dataset cora --perturb_ratio 0.3
```

You can further adjust options such as:

* `--model_type` (`gcn`, `gat`, `gt`)
* `--top_k` (number of selected concepts)
* `--train_ratio` (1, 2, 5, 10, 20, 30)

Run `python main.py --help` for the full list of arguments.

---

## 📂 Project Structure

```
.
├── main.py            # Entry point for training/evaluation
├── model/             # Model and concept bottleneck modules
├── data/              # Dataset loaders and preprocessors
├── utils/             # Training utils and evaluation metrics
├── cache/             # Saved models and logs
└── README.md
```

---

## 📊 Supported Datasets

* `Cora`
* `Citeseer`
* `PubMed`
* `Reddit`
* `WikiCS`
* Custom graphs (add to `data/`)
