###
# Supplementary for paper id: 1000
###

from loader.baseloader import BaseLoader
from loader.img_flist import ImageFilelist

import logging



logger = logging.getLogger('mylogger')


class FileDataLoader(BaseLoader):
    """Function to build data loader(s) for the specified splits given the parameters.
    """

    def __init__(self, cfg, splits, batch_size):
        super().__init__(cfg, splits, batch_size)

    def getDataset(self, root_dir, flist=None, transform=None, loader=None):
        return ImageFilelist(root_dir=root_dir, flist=flist, transform=transform)

# unit-test
if __name__ == '__main__':
    import pdb
    cfg = {
        'data_root': '',
        'train': 'data/clipart_train.txt',
        'val': 'data/real_train.txt',
        'n_workers': 4,
        'sampler': {'name': 'random'}
    }
    splits = ['train', 'val']
    data_loader = FileDataLoader(cfg, splits, batch_size=4)
    import pdb; pdb.set_trace()
    for (step, value) in enumerate(data_loader['train']):
        img, label = value
        pdb.set_trace()

