###
# Supplementary for paper id: 1000
###

from utils import calc_coeff
import torch
import numpy as np


def grl_hook(coeff):
    def fun1(grad):
        return -coeff*grad.clone()
    return fun1



class GradientReverseLayer(torch.autograd.Function):
    iter_num = 0
    max_iter = 1000
    @staticmethod
    def forward(ctx, input):
        GradientReverseLayer.iter_num += 1
        return input * 1.0

    @staticmethod
    def backward(ctx, gradOutput):
        alpha = 1
        low = 0.0
        high = 0.1
        iter_num, max_iter = GradientReverseLayer.iter_num, GradientReverseLayer.max_iter 
        coeff = calc_coeff(iter_num, high, low, alpha, max_iter)
        return -coeff * gradOutput
