from utils.misc import execute
import glob
from tqdm import tqdm

input_dir="/path/to/dir"
a2m_dir="/path/to/dir"
output_dir="/path/to/dir"

sto_files=glob.glob(input_dir+"/*.sto")
for sto_path in tqdm(sto_files):
    pdb_id=sto_path.split("/")[-1].split(".")[0]
    # print(pdb_id)
    a2m_path=a2m_dir+f"/{pdb_id}.a2m"
    # print(sto_path)
    # print(a2m_path)
    execute(
        f"esl-reformat --informat stockholm"
        f" -o {str(a2m_path)} a2m"            
        f" {str(sto_path)}"
    )
    fasta_path=output_dir+f"/{pdb_id}.fasta"
    output=""
    with open(a2m_path) as f:
        for line in f:
            line=line.strip()
            if line[0]!=">":
                output+=line
            else :
                output+="\n"+line+"\n"
    output=output.strip()
    output=output.split("\n")[:-2]
    output="\n".join(output)
    with open(fasta_path,"w") as f:
        f.write(output)