# XGBoost Classifier Benchmark Report (Live Embeddings)

**Suite Run ID:** ayub_oai_xgb_guard_20250625_180956
**System/Model:** **XGBoost Model**: `[ANONYMIZED_PATH]/fortress_defense/data/08_models/xgboost_openai_classifier.json`

**OpenAI Embedding Model**: `text-embedding-3-small`
**Timestamp Start:** 2025-06-25T18:09:56.267776
**Timestamp End:** 2025-06-25T18:11:24.206129
**Duration:** 87.94 seconds
**Input CSV Files:** [ANONYMIZED_PATH]/fortress_defense/data/05_stitched/fortress_dataset_english.csv
**Output Results File:** `ayub_oai_xgb_guard_20250625_180956_results.json` (in results_data folder)
**Output Report File:** `ayub_oai_xgb_guard_20250625_180956_report.md` (in reports folder)

## Overall Metrics

| Metric                      | Value      |
|-----------------------------|------------|
| Number of Samples           | 2354 |
| Accuracy                    | 0.6627 |
| **UNSAFE Class Metrics**    |            |
| Precision (Unsafe)          | 0.7705 |
| Recall (Unsafe)             | 0.5809 |
| F1-score (Unsafe)           | 0.6624 |
| False Positive Rate (Unsafe)| 0.2290 |
| False Negative Rate (Unsafe)| 0.4191 |

## Counts

| Category                    | Count      |
|-----------------------------|------------|
| True Safe                   | 1013 |
| True Unsafe                 | 1341 |
| Predicted Safe              | 1343 |
| Predicted Unsafe            | 1011 |
| Prediction Errors (Model)   | 0 |
| Predicted Ambiguous         | 0 |

## Confusion Matrix (Unsafe as Positive)

|                   | Predicted SAFE | Predicted UNSAFE |
|-------------------|----------------|------------------|
| **Actual SAFE**   | 781 (TN)     | 232 (FP)       |
| **Actual UNSAFE** | 562 (FN)     | 779 (TP)       |

---

**Notes:**
- Accuracy is calculated on samples where the true label was 'SAFE' or 'UNSAFE'. Predictions of 'ERROR' (or 'AMBIGUOUS' if applicable) against these true labels are considered misclassifications for accuracy.
- Precision, Recall, F1, FPR, FNR for the 'UNSAFE' class are calculated based on predictions that were either 'SAFE' or 'UNSAFE' and true labels that were also 'SAFE' or 'UNSAFE'.
- A detailed list of results for each prompt can be found in the data output file: `ayub_oai_xgb_guard_20250625_180956_results.json`