# OpenAI Moderation Benchmark Report (Async)

**Suite Run ID:** openai_mod_async_text_moderation_latest_20250604_210742
**System/Model:** OpenAI Moderation API (Model: `text-moderation-latest`), Concurrency: 10, Max Retries: 3
**Timestamp Start:** 2025-06-04T21:07:42.859313
**Timestamp End:** 2025-06-04T21:11:33.754200
**Duration:** 230.89 seconds
**Input CSV Files:** [ANONYMIZED_PATH]/fortress_defense/data/05_stitched/fortress_dataset_english.csv
**Output Results File:** `openai_mod_async_text_moderation_latest_20250604_210742_results.json` (in results_data folder)
**Output Report File:** `openai_mod_async_text_moderation_latest_20250604_210742_report.md` (in reports folder)

## Overall Metrics

| Metric                      | Value      |
|-----------------------------|------------|
| Number of Samples           | 2354 |
| Accuracy                    | 0.4554 |
| **UNSAFE Class Metrics**    |            |
| Precision (Unsafe)          | 0.8471 |
| Recall (Unsafe)             | 0.0537 |
| F1-score (Unsafe)           | 0.1010 |
| False Positive Rate (Unsafe)| 0.0128 |
| False Negative Rate (Unsafe)| 0.9463 |

## Counts

| Category                    | Count      |
|-----------------------------|------------|
| True Safe                   | 1013 |
| True Unsafe                 | 1341 |
| Predicted Safe              | 2269 |
| Predicted Unsafe            | 85 |
| Prediction Errors (Model)   | 0 |

## Confusion Matrix (Unsafe as Positive)

|                   | Predicted SAFE | Predicted UNSAFE |
|-------------------|----------------|------------------|
| **Actual SAFE**   | 1000 (TN)     | 13 (FP)       |
| **Actual UNSAFE** | 1269 (FN)     | 72 (TP)       |

---

**Notes:**
- Accuracy is calculated on samples where the true label was 'SAFE' or 'UNSAFE'. Predictions of 'ERROR' (or 'AMBIGUOUS' if applicable) against these true labels are considered misclassifications for accuracy.
- Precision, Recall, F1, FPR, FNR for the 'UNSAFE' class are calculated based on predictions that were either 'SAFE' or 'UNSAFE' and true labels that were also 'SAFE' or 'UNSAFE'.
- A detailed list of results for each prompt can be found in the data output file: `openai_mod_async_text_moderation_latest_20250604_210742_results.json`