# Patch LoRA Guard Benchmark Report

**Suite Run ID:** patch_lora_guard_20250605_041906
**System/Model:** Patch LoRA Guard - Base Model: `meta-llama/Llama-Guard-3-1B` with LoRA adapter (Device: cuda, Dtype: float16)
**Timestamp Start:** 2025-06-05T04:19:06.388518
**Timestamp End:** 2025-06-05T04:23:04.022157
**Duration:** 237.63 seconds
**Input CSV Files:** [ANONYMIZED_PATH]/fortress_defense/data/05_stitched/fortress_dataset_english.csv
**Output Results File:** `patch_lora_guard_20250605_041906_results.json` (in results_data folder)
**Output Report File:** `patch_lora_guard_20250605_041906_report.md` (in reports folder)
**LoRA Adapter Path:** `[ANONYMIZED_PATH]/fortress_defense/data/08_local_models/patch_lora_guard`
**Model Type:** Sequence Classification (LoRA-adapted)
**Max Sequence Length:** 2048
**Label Mapping:** Class 0 → SAFE, Class 1 → UNSAFE

## Overall Metrics

| Metric                      | Value      |
|-----------------------------|------------|
| Number of Samples           | 2354 |
| Accuracy                    | 0.8063 |
| **UNSAFE Class Metrics**    |            |
| Precision (Unsafe)          | 0.7778 |
| Recall (Unsafe)             | 0.9239 |
| F1-score (Unsafe)           | 0.8446 |
| False Positive Rate (Unsafe)| 0.3495 |
| False Negative Rate (Unsafe)| 0.0761 |

## Counts

| Category                    | Count      |
|-----------------------------|------------|
| True Safe                   | 1013 |
| True Unsafe                 | 1341 |
| Predicted Safe              | 761 |
| Predicted Unsafe            | 1593 |
| Prediction Errors (Model)   | 0 |

## Confusion Matrix (Unsafe as Positive)

|                   | Predicted SAFE | Predicted UNSAFE |
|-------------------|----------------|------------------|
| **Actual SAFE**   | 659 (TN)     | 354 (FP)       |
| **Actual UNSAFE** | 102 (FN)     | 1239 (TP)       |

---

**Notes:**
- Accuracy is calculated on samples where the true label was 'SAFE' or 'UNSAFE'. Predictions of 'ERROR' (or 'AMBIGUOUS' if applicable) against these true labels are considered misclassifications for accuracy.
- Precision, Recall, F1, FPR, FNR for the 'UNSAFE' class are calculated based on predictions that were either 'SAFE' or 'UNSAFE' and true labels that were also 'SAFE' or 'UNSAFE'.
- A detailed list of results for each prompt can be found in the data output file: `patch_lora_guard_20250605_041906_results.json`