# WildGuard Benchmark Report (Prompt Harmfulness)

**Suite Run ID:** wildguard_wildguard_20250602_235831
**System/Model:** WildGuard Model: `allenai/wildguard` (Device: cuda)
**Timestamp Start:** 2025-06-02T23:58:31.883697
**Timestamp End:** 2025-06-03T00:01:36.550198
**Duration:** 184.67 seconds
**Input CSV Files:** [ANONYMIZED_PATH]/fortress_defense/data/05_stitched/harmbench_behaviors_text_all.csv
**Output Results File:** `wildguard_wildguard_20250602_235831_suite_results.json` (in results_data folder)
**Output Report File:** `wildguard_wildguard_20250602_235831_report.md` (in reports folder)
**Task:** Harmful User Request Detection

## Overall Metrics

| Metric                      | Value      |
|-----------------------------|------------|
| Number of Samples           | 400 |
| Accuracy                    | 0.9925 |
| **UNSAFE Class Metrics**    |            |
| Precision (Unsafe)          | 1.0000 |
| Recall (Unsafe)             | 0.9925 |
| F1-score (Unsafe)           | 0.9962 |
| False Positive Rate (Unsafe)| 0.0000 |
| False Negative Rate (Unsafe)| 0.0075 |

## Counts

| Category                    | Count      |
|-----------------------------|------------|
| True Safe                   | 0 |
| True Unsafe                 | 400 |
| Predicted Safe              | 3 |
| Predicted Unsafe            | 397 |
| Prediction Errors (Model)   | 0 |

## Confusion Matrix (Unsafe as Positive)

|                   | Predicted SAFE | Predicted UNSAFE |
|-------------------|----------------|------------------|
| **Actual SAFE**   | 0 (TN)     | 0 (FP)       |
| **Actual UNSAFE** | 3 (FN)     | 397 (TP)       |

---

**Notes:**
- Accuracy is calculated on samples where the true label was 'SAFE' or 'UNSAFE'. Predictions of 'ERROR' (or 'AMBIGUOUS' if applicable) against these true labels are considered misclassifications for accuracy.
- Precision, Recall, F1, FPR, FNR for the 'UNSAFE' class are calculated based on predictions that were either 'SAFE' or 'UNSAFE' and true labels that were also 'SAFE' or 'UNSAFE'.
- A detailed list of results for each prompt can be found in the data output file: `wildguard_wildguard_20250602_235831_suite_results.json`