# OpenAI Moderation Benchmark Report (Async)

**Suite Run ID:** openai_mod_async_text_moderation_latest_20250604_211134
**System/Model:** OpenAI Moderation API (Model: `text-moderation-latest`), Concurrency: 10, Max Retries: 3
**Timestamp Start:** 2025-06-04T21:11:34.465337
**Timestamp End:** 2025-06-04T21:11:48.665130
**Duration:** 14.20 seconds
**Input CSV Files:** [ANONYMIZED_PATH]/fortress_defense/data/05_stitched/simple_safety_english.csv
**Output Results File:** `openai_mod_async_text_moderation_latest_20250604_211134_results.json` (in results_data folder)
**Output Report File:** `openai_mod_async_text_moderation_latest_20250604_211134_report.md` (in reports folder)

## Overall Metrics

| Metric                      | Value      |
|-----------------------------|------------|
| Number of Samples           | 100 |
| Accuracy                    | 0.4600 |
| **UNSAFE Class Metrics**    |            |
| Precision (Unsafe)          | 1.0000 |
| Recall (Unsafe)             | 0.4600 |
| F1-score (Unsafe)           | 0.6301 |
| False Positive Rate (Unsafe)| 0.0000 |
| False Negative Rate (Unsafe)| 0.5400 |

## Counts

| Category                    | Count      |
|-----------------------------|------------|
| True Safe                   | 0 |
| True Unsafe                 | 100 |
| Predicted Safe              | 54 |
| Predicted Unsafe            | 46 |
| Prediction Errors (Model)   | 0 |

## Confusion Matrix (Unsafe as Positive)

|                   | Predicted SAFE | Predicted UNSAFE |
|-------------------|----------------|------------------|
| **Actual SAFE**   | 0 (TN)     | 0 (FP)       |
| **Actual UNSAFE** | 54 (FN)     | 46 (TP)       |

---

**Notes:**
- Accuracy is calculated on samples where the true label was 'SAFE' or 'UNSAFE'. Predictions of 'ERROR' (or 'AMBIGUOUS' if applicable) against these true labels are considered misclassifications for accuracy.
- Precision, Recall, F1, FPR, FNR for the 'UNSAFE' class are calculated based on predictions that were either 'SAFE' or 'UNSAFE' and true labels that were also 'SAFE' or 'UNSAFE'.
- A detailed list of results for each prompt can be found in the data output file: `openai_mod_async_text_moderation_latest_20250604_211134_results.json`