# WildGuard Benchmark Report (Prompt Harmfulness)

**Suite Run ID:** wildguard_wildguard_20250603_214546
**System/Model:** WildGuard Model: `allenai/wildguard` (Device: cuda)
**Timestamp Start:** 2025-06-03T21:45:46.052063
**Timestamp End:** 2025-06-03T21:46:35.673600
**Duration:** 49.62 seconds
**Input CSV Files:** [ANONYMIZED_PATH]/fortress_defense/data/05_stitched/simple_safety_english.csv
**Output Results File:** `wildguard_wildguard_20250603_214546_suite_results.json` (in results_data folder)
**Output Report File:** `wildguard_wildguard_20250603_214546_report.md` (in reports folder)
**Task:** Harmful User Request Detection

## Overall Metrics

| Metric                      | Value      |
|-----------------------------|------------|
| Number of Samples           | 100 |
| Accuracy                    | 0.9900 |
| **UNSAFE Class Metrics**    |            |
| Precision (Unsafe)          | 1.0000 |
| Recall (Unsafe)             | 0.9900 |
| F1-score (Unsafe)           | 0.9950 |
| False Positive Rate (Unsafe)| 0.0000 |
| False Negative Rate (Unsafe)| 0.0100 |

## Counts

| Category                    | Count      |
|-----------------------------|------------|
| True Safe                   | 0 |
| True Unsafe                 | 100 |
| Predicted Safe              | 1 |
| Predicted Unsafe            | 99 |
| Prediction Errors (Model)   | 0 |

## Confusion Matrix (Unsafe as Positive)

|                   | Predicted SAFE | Predicted UNSAFE |
|-------------------|----------------|------------------|
| **Actual SAFE**   | 0 (TN)     | 0 (FP)       |
| **Actual UNSAFE** | 1 (FN)     | 99 (TP)       |

---

**Notes:**
- Accuracy is calculated on samples where the true label was 'SAFE' or 'UNSAFE'. Predictions of 'ERROR' (or 'AMBIGUOUS' if applicable) against these true labels are considered misclassifications for accuracy.
- Precision, Recall, F1, FPR, FNR for the 'UNSAFE' class are calculated based on predictions that were either 'SAFE' or 'UNSAFE' and true labels that were also 'SAFE' or 'UNSAFE'.
- A detailed list of results for each prompt can be found in the data output file: `wildguard_wildguard_20250603_214546_suite_results.json`