# Patch LoRA Guard Benchmark Report

**Suite Run ID:** patch_lora_guard_20250605_043519
**System/Model:** Patch LoRA Guard - Base Model: `meta-llama/Llama-Guard-3-1B` with LoRA adapter (Device: cuda, Dtype: float16)
**Timestamp Start:** 2025-06-05T04:35:19.565171
**Timestamp End:** 2025-06-05T05:14:56.252558
**Duration:** 2376.69 seconds
**Input CSV Files:** [ANONYMIZED_PATH]/fortress_defense/data/05_stitched/xsafety_multilingual_data.csv
**Output Results File:** `patch_lora_guard_20250605_043519_results.json` (in results_data folder)
**Output Report File:** `patch_lora_guard_20250605_043519_report.md` (in reports folder)
**LoRA Adapter Path:** `[ANONYMIZED_PATH]/fortress_defense/data/08_local_models/patch_lora_guard`
**Model Type:** Sequence Classification (LoRA-adapted)
**Max Sequence Length:** 2048
**Label Mapping:** Class 0 → SAFE, Class 1 → UNSAFE

## Overall Metrics

| Metric                      | Value      |
|-----------------------------|------------|
| Number of Samples           | 23664 |
| Accuracy                    | 0.8484 |
| **UNSAFE Class Metrics**    |            |
| Precision (Unsafe)          | 1.0000 |
| Recall (Unsafe)             | 0.8484 |
| F1-score (Unsafe)           | 0.9180 |
| False Positive Rate (Unsafe)| 0.0000 |
| False Negative Rate (Unsafe)| 0.1516 |

## Counts

| Category                    | Count      |
|-----------------------------|------------|
| True Safe                   | 0 |
| True Unsafe                 | 23664 |
| Predicted Safe              | 3587 |
| Predicted Unsafe            | 20077 |
| Prediction Errors (Model)   | 0 |

## Confusion Matrix (Unsafe as Positive)

|                   | Predicted SAFE | Predicted UNSAFE |
|-------------------|----------------|------------------|
| **Actual SAFE**   | 0 (TN)     | 0 (FP)       |
| **Actual UNSAFE** | 3587 (FN)     | 20077 (TP)       |

---

**Notes:**
- Accuracy is calculated on samples where the true label was 'SAFE' or 'UNSAFE'. Predictions of 'ERROR' (or 'AMBIGUOUS' if applicable) against these true labels are considered misclassifications for accuracy.
- Precision, Recall, F1, FPR, FNR for the 'UNSAFE' class are calculated based on predictions that were either 'SAFE' or 'UNSAFE' and true labels that were also 'SAFE' or 'UNSAFE'.
- A detailed list of results for each prompt can be found in the data output file: `patch_lora_guard_20250605_043519_results.json`