from pathlib import Path
from typing import List, Dict, Tuple, Any, Set, Optional
import os

SAFE_CATEGORIES = [
    "information_retrieval", "problem_solving", "learning", 
    "content_creation", "ethical_inquiry"
]
UNSAFE_CATEGORIES = [
    "s1_violent_crimes", "s2_non_violent_crimes", "s3_sex_related_crimes", 
    "s4_child_sexual_exploitation", "s5_defamation", "s6_specialized_advice", 
    "s7_privacy", "s8_intellectual_property", "s9_indiscriminate_weapons", 
    "s10_hate", "s11_suicide_self_harm", "s12_sexual_content", "s13_elections"
]
BASE_PROJECT_DIR = Path(os.path.dirname(os.path.dirname(os.path.abspath(__file__))))
EXPERIMENT_DIR = BASE_PROJECT_DIR / "experiments" / "weight_tuning"
SETTINGS_PATH = BASE_PROJECT_DIR / "config" / "settings.yaml"
SETTINGS_BACKUP_PATH = BASE_PROJECT_DIR / "config" / "settings.yaml.weight_tuning_backup"

BASE_OUTPUT_DIR = BASE_PROJECT_DIR / "benchmarks"
REPORTS_DIR = BASE_OUTPUT_DIR / "reports"
RESULTS_DATA_DIR = BASE_OUTPUT_DIR / "results_data"

FORTRESS_CONFIG_DIR = BASE_PROJECT_DIR / "config"
FORTRESS_SETTINGS_PATH = FORTRESS_CONFIG_DIR / "settings.yaml"
FORTRESS_EXPERIMENT_CATALOGUE = FORTRESS_CONFIG_DIR / "experiment_catalogue"
FORTRESS_DEFAULT_CONFIG = FORTRESS_EXPERIMENT_CATALOGUE / "default.yaml"
                                                       
BENCHMARK_CSVS: Dict[str, str] = {   
    "aegis_v2_english": str(BASE_PROJECT_DIR / "data/05_stitched/aegis_v2_english.csv"),        
    "ailuminate_english": str(BASE_PROJECT_DIR / "data/05_stitched/ailuminate_english.csv"),
    "harmbench_english": str(BASE_PROJECT_DIR / "data/05_stitched/harmbench_english.csv"),
    "openai_moderation_english": str(BASE_PROJECT_DIR / "data/05_stitched/openai_moderation_english.csv"),
    "fortress_dataset_english": str(BASE_PROJECT_DIR / "data/05_stitched/fortress_dataset_english.csv"),
    "simple_safety_english": str(BASE_PROJECT_DIR / "data/05_stitched/simple_safety_english.csv"),
    "wild_jailbreak_english": str(BASE_PROJECT_DIR / "data/05_stitched/wild_jailbreak_english.csv"),
    "jailbreakbench_english": str(BASE_PROJECT_DIR / "data/05_stitched/jailbreakbench_judge_comparison_dataset.csv"),
    "xsafety_multilingual": str(BASE_PROJECT_DIR / "data/05_stitched/xsafety_multilingual.csv"),
    "xstest_english": str(BASE_PROJECT_DIR / "data/05_stitched/xstest_english.csv"),
}

DISCORD_WEBHOOK_URL = ""

FORTRESS_CONFIGS: Dict[str, Tuple[str, str]] = {
    "FORTRESS GEMMA 1B (Default)": ("fortress_1b_default", "gemma_1b_default.yaml"),
    "FORTRESS GEMMA 1B (Perplexity Only)": ("fortress_1b_perplexity_only", "gemma_1b_perplexity_only.yaml"),
    "FORTRESS GEMMA 1B (Retrieval Only)": ("fortress_1b_retrieval_only", "gemma_1b_retrieval_only.yaml"),
    "FORTRESS GEMMA 1B (All Augmented)": ("fortress_1b_all_augmented", "gemma_1b_all_augmented.yaml"),
    "FORTRESS GEMMA 1B (No Dynamic Perplexity)": ("fortress_1b_no_dynamic_perplexity", "gemma_1b_no_dynamic_perplexity.yaml"),
    "FORTRESS GEMMA 1B (Global Optimized Static Perplexity)": ("fortress_1b_global_optimized_static_perplexity", "gemma_1b_global_optimized_perplexity_param.yaml"),



    "FORTRESS GEMMA 4B (Default)": ("fortress_4b_default", "gemma_4b_default.yaml"),
                                                                                                              
                                                                                                           
    "FORTRESS GEMMA 4B (All Augmented)": ("fortress_4b_all_augmented", "gemma_4b_all_augmented.yaml"),
                                                                                                                                
    
                                                                                                  
                                                                                                                
                                                                                                                   

    "FORTRESS QWEN 0.6B (Default)": ("fortress_qwen_0_6b_default", "qwen_0.6b_default.yaml"),
                                                                                                                    
                                                                                                                       
    "FORTRESS QWEN 0.6B (All Augmented)": ("fortress_qwen_0_6b_all_augmented", "qwen_0.6b_all_augmented.yaml"),
                                                                                                                                         


                                                                                               
                                                                                                                    
                                                                                                                       
                                                                                                                 
                                                                                                                                         
    
    
    "FORTRESS QWEN 4B (Default)": ("fortress_qwen_4b_default", "qwen_4b_default.yaml"),
                                                                                                              
                                                                                                                 
    "FORTRESS QWEN 4B (All Augmented)": ("fortress_qwen_4b_all_augmented", "qwen_4b_all_augmented.yaml"),
                                                                                                                                   

    "FORTRESS BGE M3 (Retrieval Only)": ("fortress_bge_m3_retrieval_only", "bge_m3_retrieval_only.yaml"),

}
