# XGBoost Classifier Benchmark Report (Live Embeddings)

**Suite Run ID:** ayub_oai_xgb_guard_20250625_180743
**System/Model:** **XGBoost Model**: `[ANONYMIZED_PATH]/fortress_defense/data/08_models/xgboost_openai_classifier.json`

**OpenAI Embedding Model**: `text-embedding-3-small`
**Timestamp Start:** 2025-06-25T18:07:43.686447
**Timestamp End:** 2025-06-25T18:08:54.376055
**Duration:** 70.69 seconds
**Input CSV Files:** [ANONYMIZED_PATH]/fortress_defense/data/05_stitched/aegis_v2_english.csv
**Output Results File:** `ayub_oai_xgb_guard_20250625_180743_results.json` (in results_data folder)
**Output Report File:** `ayub_oai_xgb_guard_20250625_180743_report.md` (in reports folder)

## Overall Metrics

| Metric                      | Value      |
|-----------------------------|------------|
| Number of Samples           | 1964 |
| Accuracy                    | 0.5275 |
| **UNSAFE Class Metrics**    |            |
| Precision (Unsafe)          | 0.6215 |
| Recall (Unsafe)             | 0.3163 |
| F1-score (Unsafe)           | 0.4193 |
| False Positive Rate (Unsafe)| 0.2254 |
| False Negative Rate (Unsafe)| 0.6837 |

## Counts

| Category                    | Count      |
|-----------------------------|------------|
| True Safe                   | 905 |
| True Unsafe                 | 1059 |
| Predicted Safe              | 1425 |
| Predicted Unsafe            | 539 |
| Prediction Errors (Model)   | 0 |
| Predicted Ambiguous         | 0 |

## Confusion Matrix (Unsafe as Positive)

|                   | Predicted SAFE | Predicted UNSAFE |
|-------------------|----------------|------------------|
| **Actual SAFE**   | 701 (TN)     | 204 (FP)       |
| **Actual UNSAFE** | 724 (FN)     | 335 (TP)       |

---

**Notes:**
- Accuracy is calculated on samples where the true label was 'SAFE' or 'UNSAFE'. Predictions of 'ERROR' (or 'AMBIGUOUS' if applicable) against these true labels are considered misclassifications for accuracy.
- Precision, Recall, F1, FPR, FNR for the 'UNSAFE' class are calculated based on predictions that were either 'SAFE' or 'UNSAFE' and true labels that were also 'SAFE' or 'UNSAFE'.
- A detailed list of results for each prompt can be found in the data output file: `ayub_oai_xgb_guard_20250625_180743_results.json`