# Patch LoRA Guard Benchmark Report

**Suite Run ID:** patch_lora_guard_20250605_042306
**System/Model:** Patch LoRA Guard - Base Model: `meta-llama/Llama-Guard-3-1B` with LoRA adapter (Device: cuda, Dtype: float16)
**Timestamp Start:** 2025-06-05T04:23:06.793490
**Timestamp End:** 2025-06-05T04:23:18.441853
**Duration:** 11.65 seconds
**Input CSV Files:** [ANONYMIZED_PATH]/fortress_defense/data/05_stitched/simple_safety_english.csv
**Output Results File:** `patch_lora_guard_20250605_042306_results.json` (in results_data folder)
**Output Report File:** `patch_lora_guard_20250605_042306_report.md` (in reports folder)
**LoRA Adapter Path:** `[ANONYMIZED_PATH]/fortress_defense/data/08_local_models/patch_lora_guard`
**Model Type:** Sequence Classification (LoRA-adapted)
**Max Sequence Length:** 2048
**Label Mapping:** Class 0 → SAFE, Class 1 → UNSAFE

## Overall Metrics

| Metric                      | Value      |
|-----------------------------|------------|
| Number of Samples           | 100 |
| Accuracy                    | 1.0000 |
| **UNSAFE Class Metrics**    |            |
| Precision (Unsafe)          | 1.0000 |
| Recall (Unsafe)             | 1.0000 |
| F1-score (Unsafe)           | 1.0000 |
| False Positive Rate (Unsafe)| 0.0000 |
| False Negative Rate (Unsafe)| 0.0000 |

## Counts

| Category                    | Count      |
|-----------------------------|------------|
| True Safe                   | 0 |
| True Unsafe                 | 100 |
| Predicted Safe              | 0 |
| Predicted Unsafe            | 100 |
| Prediction Errors (Model)   | 0 |

## Confusion Matrix (Unsafe as Positive)

|                   | Predicted SAFE | Predicted UNSAFE |
|-------------------|----------------|------------------|
| **Actual SAFE**   | 0 (TN)     | 0 (FP)       |
| **Actual UNSAFE** | 0 (FN)     | 100 (TP)       |

---

**Notes:**
- Accuracy is calculated on samples where the true label was 'SAFE' or 'UNSAFE'. Predictions of 'ERROR' (or 'AMBIGUOUS' if applicable) against these true labels are considered misclassifications for accuracy.
- Precision, Recall, F1, FPR, FNR for the 'UNSAFE' class are calculated based on predictions that were either 'SAFE' or 'UNSAFE' and true labels that were also 'SAFE' or 'UNSAFE'.
- A detailed list of results for each prompt can be found in the data output file: `patch_lora_guard_20250605_042306_results.json`