# OpenAI Moderation Benchmark Report (Async)

**Suite Run ID:** openai_mod_async_text_moderation_latest_20250604_220248
**System/Model:** OpenAI Moderation API (Model: `text-moderation-latest`), Concurrency: 10, Max Retries: 3
**Timestamp Start:** 2025-06-04T22:02:48.996513
**Timestamp End:** 2025-06-04T22:03:34.864602
**Duration:** 45.87 seconds
**Input CSV Files:** [ANONYMIZED_PATH]/fortress_defense/data/05_stitched/xstest_english_benchmark.csv
**Output Results File:** `openai_mod_async_text_moderation_latest_20250604_220248_results.json` (in results_data folder)
**Output Report File:** `openai_mod_async_text_moderation_latest_20250604_220248_report.md` (in reports folder)

## Overall Metrics

| Metric                      | Value      |
|-----------------------------|------------|
| Number of Samples           | 450 |
| Accuracy                    | 0.7178 |
| **UNSAFE Class Metrics**    |            |
| Precision (Unsafe)          | 0.8842 |
| Recall (Unsafe)             | 0.4200 |
| F1-score (Unsafe)           | 0.5695 |
| False Positive Rate (Unsafe)| 0.0440 |
| False Negative Rate (Unsafe)| 0.5800 |

## Counts

| Category                    | Count      |
|-----------------------------|------------|
| True Safe                   | 250 |
| True Unsafe                 | 200 |
| Predicted Safe              | 355 |
| Predicted Unsafe            | 95 |
| Prediction Errors (Model)   | 0 |

## Confusion Matrix (Unsafe as Positive)

|                   | Predicted SAFE | Predicted UNSAFE |
|-------------------|----------------|------------------|
| **Actual SAFE**   | 239 (TN)     | 11 (FP)       |
| **Actual UNSAFE** | 116 (FN)     | 84 (TP)       |

---

**Notes:**
- Accuracy is calculated on samples where the true label was 'SAFE' or 'UNSAFE'. Predictions of 'ERROR' (or 'AMBIGUOUS' if applicable) against these true labels are considered misclassifications for accuracy.
- Precision, Recall, F1, FPR, FNR for the 'UNSAFE' class are calculated based on predictions that were either 'SAFE' or 'UNSAFE' and true labels that were also 'SAFE' or 'UNSAFE'.
- A detailed list of results for each prompt can be found in the data output file: `openai_mod_async_text_moderation_latest_20250604_220248_results.json`