\
from pathlib import Path
import logging

logger = logging.getLogger(__name__)

def find_csv_files(input_path: Path) -> list[Path]:
    """
    Finds all CSV files in the given path (can be a file or directory).
    """
    csv_files = []
    if input_path.is_file():
        if input_path.suffix.lower() == ".csv":
            csv_files.append(input_path)
        else:
            logger.warning(f"Input path is a file but not a CSV: {input_path}")
    elif input_path.is_dir():
        csv_files.extend(list(input_path.rglob("*.csv")))                             
        if not csv_files:
            logger.warning(f"No CSV files found in directory: {input_path}")
    else:
        logger.error(f"Input path is not a valid file or directory: {input_path}")
    return csv_files

                                                          
