function cmap = my_colormap_rb(M)
% Input: Matrix M
% Output: Colormap ranging from red to blue with zero values in white

% Find the minimum and maximum values in the matrix
min_val = min(M(:));
max_val = max(M(:));

% Define colors
b = [0 0 1]; % Blue
r = [1 0 0]; % Red
w = .99*ones(1,3); % White

% Generate colormap
n = 256; % Number of color levels

% Interpolate colors based on the range of input matrix
if min_val >= 0
    x = linspace(min_val, max_val, n);
    cmap = interp1([min_val, max_val], [w; b], x);
elseif max_val <= 0
    x = linspace(min_val, max_val, n);
    cmap = interp1([min_val, max_val], [r; w], x);
else
    zero_ratio = -min_val / (max_val - min_val);
    cmap_neg = interp1([min_val, 0], [r; w], linspace(min_val, 0, round(n * zero_ratio)));
    cmap_pos = interp1([0, max_val], [w; b], linspace(0, max_val, n - round(n * zero_ratio) + 1));
    cmap = [cmap_neg; cmap_pos];
end