function [ output_args ] = plotAllSubjectsAverage( quantity, senderMI, receiverMI, time, figTitle )
%PLOTALLSUBJECTSAVERAGE Summary of this function goes here
%   Detailed explanation goes here
    f = 14;
    width = 1.2;

    delaymax = 80;
        
    figure('units','normalized','outerposition',[0 0 1 1]);

    axes('Position', [0.1, 0.6, 0.8, 0.1]);
    meanSendMI = mean(senderMI(:, 151:351), 1);
    semSendMI = std(senderMI(:, 151:351), [], 1)/sqrt(size(senderMI,1));
    plot(meanSendMI,'linewidth',width,'color','r');
    shadedErrorBar(1:numel(meanSendMI),meanSendMI,semSendMI,'lineProps','r')
    axis([0 200 -Inf Inf]);
    %set(gca, 'YAxisLocation', 'right')
%     set(gca,'XTick',[0 50 100 150]);
%     set(gca,'XTickLabel',[time(151) time(201) time(251) time(301)]);
    set(gca,'XTick',[]);
    ax = gca;
    ax.FontSize = 16;
    ylabel('MI sender (bits)','fontsize',f,'color','r');
    
    title(figTitle, 'fontsize', 20)
    
    axes('Position', [0.1, 0.3, 0.8, 0.3]);
    imagesc(squeeze(mean(quantity(:,151:351,1:delaymax), 1))');
%     set(gca,'XTick',[0 50 100 150]);
%     set(gca,'XTickLabel',[time(151) time(201) time(251) time(301)]);
    set(gca,'XTick',[]);

    yTickLabels = get(gca, 'YTickLabel');
    for i = 1:length(yTickLabels)-1
        yTickLabels{i} = num2str(2 * str2num(yTickLabels{i}));
    end
    yTickLabels{length(yTickLabels)}=[];
    
    ylabel('delay (ms)');
    
    yTicks = delaymax - get(gca, 'YTick');
    yTicks = [delaymax yTicks(1:(length(yTicks) - 1))];
    set(gca, 'YTick', sort(yTicks));

    set(gca,'YTickLabel',yTickLabels);
    ax = gca;
    ax.FontSize = 16;
    c = colorbar('location','Manual', 'position', [0.91 0.31 0.01 0.28]);
    ylabel(c, '(bits)');
    c.FontSize = 14;
    ca = caxis;
    caxis([0 ca(2)]);
    
    
    
    axes('Position', [0.1, 0.2, 0.8, 0.1]);
    meanSendMI = mean(receiverMI(:, 151:351), 1);
    semSendMI = std(receiverMI(:, 151:351), [], 1)/sqrt(size(receiverMI,1));
    plot(meanSendMI,'linewidth',width,'color','b');
    shadedErrorBar(1:numel(meanSendMI),meanSendMI,semSendMI,'lineProps','b')
    %plot(mean(receiverMI(:, 151:351), 1),'linewidth',width,'color','b');
    axis([0 200 -Inf Inf]);
    %set(gca, 'YAxisLocation', 'right')
    set(gca,'XTick',[0 50 75 100 150]);
    set(gca,'XTickLabel',[time(151) time(201) time(226) time(251) time(301)]);
    ax = gca;
    ax.FontSize = 16;
    ylabel('MI receiver (bits)','fontsize',f,'color','b');
    xlabel('Time at receiver (ms)','fontsize',f);
    
    %ah = axes('Position', [0.1, 0.2, 0.8, 0.5], 'Visible', 'off');
    %[m, mIdx] = max(mean(senderMI(:, 151:351), 1));
    %line('XData', [mIdx mIdx], 'YData', [0 1],'parent', ah, 'linewidth', 1, 'LineStyle', '--');
    axis([0 200 0 Inf]);

end

