%% Avg time profile conditioned
% Here using clusters statistics for pairs comparison

%secondMaxLE = 'allSubjects_EEG_SecondMaxConfounders_onLE';
secondMaxLE = 'allSubjects_EEG_SecondMaxConfounders_onLE';
frontMinLE = 'allSubjects_EEG_FrontMinConfounders_onLE';
secondMaxRE = 'allSubjects_EEG_SecondMaxConfounders_onRE';
frontMinRE = 'allSubjects_EEG_FrontMinConfounders_onRE';

% Parameters settings for plot
params.tMin = 191; % Window of interest after the stimulus presentation
params.tMax = 271; % 277
params.time = (params.tMin-151:2:2*(params.tMax-params.tMin)+params.tMin-151);
params.dMin = 5; % delay range of the two FIT clusters
params.dMax = 50;
params.linew = 1.5;
params.adjSigTime = 10; % Consecutive time points that have to be significant to be plotted (i.e. at least 10ms)
params.sign_threshold = 0.025;


figure()

% LE contralateral
subplot(1,2,1)

% Original measure
load(secondMaxLE, 'FITLE', 'FITLESh', 'cFITLE', 'cFITLESh') % secondMax also contains the original measures
FITLE_timeEv = mean(squeeze(mean(FITLE(1,:,params.tMin:params.tMax,params.dMin:params.dMax),2))',1);
FITLESh_timeEv = squeeze(mean(mean(FITLESh(1,:,params.tMin:params.tMax,params.dMin:params.dMax,:),2),4));
sig_time_points = time_significance_mask(FITLE_timeEv, FITLESh_timeEv, params);
c = [0 0 1];
plot(params.time,FITLE_timeEv,'linewidth', params.linew+1, 'color', c);
hold on
plot(params.time(sig_time_points), FITLE_timeEv(sig_time_points), 'o', 'color', c, 'MarkerFaceColor', c, 'MarkerSize', 11)

% LE secondMax (sender) confounder
cFITLE_emitter_timeEv = mean(squeeze(mean(cFITLE(1,:,params.tMin:params.tMax,params.dMin:params.dMax),2))',1);
cFITLESh_emitter_timeEv = squeeze(mean(mean(cFITLESh(1,:,params.tMin:params.tMax,params.dMin:params.dMax,:),2),4));
sig_time_points = time_significance_mask(cFITLE_emitter_timeEv, cFITLESh_emitter_timeEv, params);
c = [0 0.8 0];
plot(params.time,cFITLE_emitter_timeEv,'linewidth', params.linew, 'color', c);
plot(params.time(sig_time_points), cFITLE_emitter_timeEv(sig_time_points), 'o', 'color', c, 'MarkerFaceColor', c)

% LE frontMin confounders
load(frontMinLE, 'cFITLE', 'cFITLESh')
cFITLE_far_timeEv = mean(squeeze(mean(cFITLE(1,:,params.tMin:params.tMax,params.dMin:params.dMax),2))',1);
cFITLESh_far_timeEv = squeeze(mean(mean(cFITLESh(1,:,params.tMin:params.tMax,params.dMin:params.dMax,:),2),4));
sig_time_points = time_significance_mask(cFITLE_far_timeEv, cFITLESh_far_timeEv, params);
c = [255/256 165/256 0];
plot(params.time,cFITLE_far_timeEv,'linewidth', params.linew, 'color', c);
plot(params.time(sig_time_points), cFITLE_far_timeEv(sig_time_points), 'o', 'color', c, 'MarkerFaceColor', c)

ax = gca;
ax.FontSize = 14;
title('LE contralateral','fontsize',18)
lgd = legend('FIT','Significant points','cFIT strong confounders','Significant points','cFIT weak confounders','Significant points');
lgd.FontSize = 14;
xlim([params.tMin-151,2*(params.tMax-params.tMin)+params.tMin-151])
ylim([0, max(FITLE_timeEv)+0.0001])
xlabel('Time from stimulus onset [ms]','fontsize',14)

% RE contralateral
subplot(1,2,2)

% RE original measure
load(secondMaxRE, 'FITRE', 'FITRESh', 'cFITRE', 'cFITRESh') % secondMax also contains the original measures
FITRE_timeEv = mean(squeeze(mean(FITRE(1,:,params.tMin:params.tMax,params.dMin:params.dMax),2))',1);
FITRESh_timeEv = squeeze(mean(mean(FITRESh(1,:,params.tMin:params.tMax,params.dMin:params.dMax,:),2),4));
sig_time_points = time_significance_mask(FITRE_timeEv, FITRESh_timeEv, params);
c = [0 0 1];
plot(params.time,FITRE_timeEv,'linewidth', params.linew+1, 'color', c);
hold on
plot(params.time(sig_time_points), FITRE_timeEv(sig_time_points), 'o', 'color', c, 'MarkerFaceColor', c, 'MarkerSize', 11)

% RE secondMax (sender) confounders
cFITRE_emitter_timeEv = mean(squeeze(mean(cFITRE(1,:,params.tMin:params.tMax,params.dMin:params.dMax),2))',1);
cFITRESh_emitter_timeEv = squeeze(mean(mean(cFITRESh(1,:,params.tMin:params.tMax,params.dMin:params.dMax,:),2),4));
sig_time_points = time_significance_mask(cFITRE_emitter_timeEv, cFITRESh_emitter_timeEv, params);
c = [0 0.8 0];
plot(params.time,cFITRE_emitter_timeEv,'linewidth', params.linew, 'color', c);
plot(params.time(sig_time_points), cFITRE_emitter_timeEv(sig_time_points), 'o', 'color', c, 'MarkerFaceColor', c)

% RE frontMin confounders
load(frontMinRE, 'cFITRE', 'cFITRESh')
cFITRE_far_timeEv = mean(squeeze(mean(cFITRE(1,:,params.tMin:params.tMax,params.dMin:params.dMax),2))',1);
cFITRESh_far_timeEv = squeeze(mean(mean(cFITRESh(1,:,params.tMin:params.tMax,params.dMin:params.dMax,:),2),4));
sig_time_points = time_significance_mask(cFITRE_far_timeEv, cFITRESh_far_timeEv, params);
c = [255/256 165/256 0];
plot(params.time,cFITRE_far_timeEv,'linewidth', params.linew, 'color', c);
plot(params.time(sig_time_points), cFITRE_far_timeEv(sig_time_points), 'o', 'color', c, 'MarkerFaceColor', c)

ax = gca;
ax.FontSize = 14;
xlim([params.tMin-151,2*(params.tMax-params.tMin)+params.tMin-151])
ylim([0, max(FITRE_timeEv)+0.00007])
xlabel('Time from stimulus onset [ms]','fontsize',14)
title('RE contralateral','fontsize',18)

sgtitle('FIT and cFIT time profiles, different conditionings', 'fontsize',22)
