function compute_deltaDI_pair(Xlab,Ylab,roiX,tmproiX,roiY,tmproiY,sigTime,opts,params,paths,band_label)
% within band computation of delta Transfer Entropy

% Initialize structures for the parfor loop
infoTransf_maps = [];
infoTransfSh_maps = [];

validXlab = matlab.lang.makeValidName(Xlab);
validYlab = matlab.lang.makeValidName(Ylab);

disp(['deltaDI analysis between regions ', Xlab, ' and ', Ylab])
for subjIdx = 1:params.nSubj
    neural = [];
    % Loading behavioral and neural features for the subject
    
    behav = load([paths.dataPath, '/behavioral/S', num2str(subjIdx)]);
    neural = load([paths.dataPath, '/Wilming_bands/',band_label,'/S', num2str(subjIdx)]);
        
    if params.all_trials
        [subjInfoTransf_maps_all,subjInfoTransfSh_maps_all] = compute_deltaDI_all_trials(neural,behav,sigTime,roiX,roiY,tmproiX,tmproiY,validXlab,validYlab,params,opts,band_label);
        for featIdx = 1:numel(params.selected_features)
            featLab = params.selected_features{featIdx};
            for sS = 1:numel(subjInfoTransf_maps_all.(featLab).DI) % loop over stim values
                infoTransf_maps.all.(band_label).(featLab).DI{subjIdx}{sS} = subjInfoTransf_maps_all.(featLab).DI{sS};
                infoTransfSh_maps.all.(band_label).(featLab).DI{subjIdx}{sS} = subjInfoTransfSh_maps_all.(featLab).DI{sS};
            end
            infoTransf_maps.all.(band_label).(featLab).deltaDI{subjIdx} = subjInfoTransf_maps_all.(featLab).deltaDI;
            infoTransfSh_maps.all.(band_label).(featLab).deltaDI{subjIdx} = subjInfoTransfSh_maps_all.(featLab).deltaDI;
        end
    end
end % end subj loop

fname = [paths.savePath,'/infoTransf_deltaDI_',params.codeVersion,'_',Xlab,'_',Ylab,'_',date];

% Build structure of variables we want to save in the parfor loop
savevars = [];
savevars.infoTransf_maps=infoTransf_maps;
savevars.infoTransfSh_maps=infoTransfSh_maps;
savevars.params=params; savevars.opts=opts; savevars.paths = paths;
savevars.roiX=roiX; savevars.roiY=roiY; savevars.Xlab=Xlab; savevars.Ylab=Ylab;
savevars.sigTime.X=sigTime.(band_label).(validXlab); savevars.sigTime.Y=sigTime.(band_label).(validYlab);
% savevars.delays.min = minDelay; savevars.delays.max = maxDelay;

parsave(fname,savevars)
end

