function compute_infoTransf_pair(Xlab,Ylab,roiX,tmproiX,roiY,tmproiY,sigTime,opts,params,paths,band_label)
% within band computation
% v1 + max_delay for non-reduced commWindows

% Initialize structures for the parfor loop
infoTransf_maps = [];
infoTransfSh_maps = [];

validXlab = matlab.lang.makeValidName(Xlab);
validYlab = matlab.lang.makeValidName(Ylab);

disp(['Information transfer analysis between regions ', Xlab, ' and ', Ylab])
for subjIdx = 1:params.nSubj
    neural = [];
    % Loading behavioral and neural features for the subject
    
    behav = load([paths.dataPath, '/behavioral/S', num2str(subjIdx)]);
    neural = load([paths.dataPath, '/Wilming_bands/',band_label,'/S', num2str(subjIdx)]);
        
    if params.all_trials
        [subjInfoTransf_maps_all,subjInfoTransfSh_maps_all] = compute_DI_FIT_all_trials(neural,behav,sigTime,roiX,roiY,tmproiX,tmproiY,validXlab,validYlab,params,opts,band_label);
        for featIdx = 1:numel(params.selected_features)
            featLab = params.selected_features{featIdx};
            infoTransf_maps.all.(band_label).(featLab).DI{subjIdx} = subjInfoTransf_maps_all.(featLab).DI;
            infoTransf_maps.all.(band_label).(featLab).FIT_S{subjIdx} = subjInfoTransf_maps_all.(featLab).FIT_S;
            infoTransf_maps.all.(band_label).(featLab).FIT_C{subjIdx} = subjInfoTransf_maps_all.(featLab).FIT_C;
            infoTransf_maps.all.(band_label).(featLab).DFI_S{subjIdx} = subjInfoTransf_maps_all.(featLab).DFI_S;
            infoTransf_maps.all.(band_label).(featLab).DFI_C{subjIdx} = subjInfoTransf_maps_all.(featLab).DFI_C;

            infoTransfSh_maps.all.(band_label).(featLab).DI{subjIdx} = subjInfoTransfSh_maps_all.(featLab).DI;
            infoTransfSh_maps.all.(band_label).(featLab).FIT_S{subjIdx} = subjInfoTransfSh_maps_all.(featLab).FIT_S;
            infoTransfSh_maps.all.(band_label).(featLab).FIT_C{subjIdx} = subjInfoTransfSh_maps_all.(featLab).FIT_C;
            infoTransfSh_maps.all.(band_label).(featLab).DFI_S{subjIdx} = subjInfoTransfSh_maps_all.(featLab).DFI_S;
            infoTransfSh_maps.all.(band_label).(featLab).DFI_C{subjIdx} = subjInfoTransfSh_maps_all.(featLab).DFI_C;
        end
    end
    % Filling the final structure that will be saved for 'all' trials
    if params.correrr_trials
        [subjInfoTransf_maps_corr,subjInfoTransf_maps_err] = compute_DI_FIT_correrr_trials(neural,behav,sigTime,roiX,roiY,tmproiX,tmproiY,validXlab,validYlab,params,opts,band_label);
        % Filling the final structure that will be saved for separate 'corr' and 'err' trials
        for featIdx = 1:numel(params.selected_features)
            featLab = params.selected_features{featIdx};
            % Correct trials 
            infoTransf_maps.corr.(band_label).(featLab).DI{subjIdx} = subjInfoTransf_maps_corr.(featLab).DI;
            infoTransf_maps.corr.(band_label).(featLab).FIT_S{subjIdx} = subjInfoTransf_maps_corr.(featLab).FIT_S;
            infoTransf_maps.corr.(band_label).(featLab).DFI_S{subjIdx} = subjInfoTransf_maps_corr.(featLab).DFI_S;

            infoTransf_maps.err.(band_label).(featLab).DI{subjIdx} = subjInfoTransf_maps_err.(featLab).DI;
            infoTransf_maps.err.(band_label).(featLab).FIT_S{subjIdx} = subjInfoTransf_maps_err.(featLab).FIT_S;
            infoTransf_maps.err.(band_label).(featLab).DFI_S{subjIdx} = subjInfoTransf_maps_err.(featLab).DFI_S;
        end
    end
end % end subj loop

fname = [paths.savePath,'/infoTransf_',params.codeVersion,'_',Xlab,'_',Ylab,'_',date];

% Build structure of variables we want to save in the parfor loop
savevars = [];
savevars.infoTransf_maps=infoTransf_maps;
savevars.infoTransfSh_maps=infoTransfSh_maps;
savevars.params=params; savevars.opts=opts; savevars.paths = paths;
savevars.roiX=roiX; savevars.roiY=roiY; savevars.Xlab=Xlab; savevars.Ylab=Ylab;
savevars.sigTime.X=sigTime.(band_label).(validXlab); savevars.sigTime.Y=sigTime.(band_label).(validYlab);
% savevars.delays.min = minDelay; savevars.delays.max = maxDelay;

parsave(fname,savevars)
end

