function plot_connectivity_matrix_visNet_v3(connStrenghts,sessConnStrenghts,staticNetworks,computedROIs,computedROIsCols,sel_time_window,params,sort_idxs,fSize,paths)
% added graph plot

for roiIdx = 1:numel(computedROIs)
    ROIs_label{roiIdx} = ['\color[rgb]{',num2str(computedROIsCols(roiIdx,:),2),'} ',computedROIs{roiIdx}];
end

maxY=max(max(connStrenghts.all.(params.info_type{2}).(params.band_label)));
maxY=max(max([max(connStrenghts.all.(params.info_type{3}).(params.band_label)),maxY]));

%figure();
fig=figure('Position', [20, 220, 1200, 330]);
axes
axis('square') 
for infoIdx = 1:numel(params.info_type)
    infoLab = params.info_type{infoIdx};
    
    subplot(1,numel(params.info_type),infoIdx)
    imagesc(connStrenghts.all.(infoLab).(params.band_label)(sort_idxs,sort_idxs))
    xlabel('receiver')
    ylabel('emitter')
    set(gca, 'XTick',1:numel(computedROIs), 'XTickLabel', ROIs_label(sort_idxs),'FontSize',fSize)
    set(gca, 'YTick',1:numel(computedROIs), 'YTickLabel', ROIs_label(sort_idxs),'FontSize',fSize)
    title(infoLab)
    colorbar()
    if infoIdx > 1
        caxis([0, maxY])
    end
end
sgtitle(['Connectivity matrices T = [',num2str(sel_time_window(1)),',',num2str(sel_time_window(2)),'], ', params.bands_labels{params.bandIdx}])
if params.save_figures
    fname = [paths.figuresPath,'\connMatrix_DI_FIT_',params.across_subj_method,'_',date,'.png'];
    saveas(fig,fname)
    fname = [paths.figuresPath,'\connMatrix_DI_FIT_',params.across_subj_method,'_',date,'.fig'];
    saveas(fig,fname)
    fname = [paths.figuresPath,'\connMatrix_DI_FIT_',params.across_subj_method,'_',date,'.svg'];
    fig.Renderer = 'painters';
    saveas(fig,fname,'svg')
end

% Plot corr/err maps:
maxY=max(max([connStrenghts.corr.(params.info_type{2}).(params.band_label);connStrenghts.err.(params.info_type{2}).(params.band_label)]));

% Plot masked connectivity matrices
fig=figure('Position', [20, 220, 1200, 330]);
axes
axis('square') 
    
subplot(1,2,1)
imagesc(connStrenghts.corr.(params.info_type{2}).(params.band_label)(sort_idxs,sort_idxs))
xlabel('receiver')
ylabel('emitter')
set(gca, 'XTick',1:numel(computedROIs), 'XTickLabel', ROIs_label(sort_idxs),'FontSize',fSize)
set(gca, 'YTick',1:numel(computedROIs), 'YTickLabel', ROIs_label(sort_idxs),'FontSize',fSize)
title('Correct')
colorbar()
if infoIdx > 1
    caxis([0, maxY])
end

subplot(1,2,2)
imagesc(connStrenghts.err.(params.info_type{2}).(params.band_label)(sort_idxs,sort_idxs))
xlabel('receiver')
ylabel('emitter')
set(gca, 'XTick',1:numel(computedROIs), 'XTickLabel', ROIs_label(sort_idxs),'FontSize',fSize)
set(gca, 'YTick',1:numel(computedROIs), 'YTickLabel', ROIs_label(sort_idxs),'FontSize',fSize)
title('Error')
colorbar()
if infoIdx > 1
    caxis([0, maxY])
end

sgtitle(['FIT conn. matrix corr. vs err. T = [',num2str(sel_time_window(1)),',',num2str(sel_time_window(2)),'], ', params.bands_labels{params.bandIdx}])
if params.save_figures
    fname = [paths.figuresPath,'\connMatrix_FIT_corrErr_',params.across_subj_method,'_',date,'.png'];
    saveas(fig,fname)
end

%% Graph plot

if numel(computedROIs) == 4 % Only plot networks for V1, V3A, V3CD, LO3 (since in static_network_plot_v3 we specify the nodes locations and colors)
    figAbs = figure('Position', [56, 219, 1189, 379]);
    figSig = figure('Position', [56, 219, 1189, 379]);
    figAll = figure('Position', [56, 219, 1189, 379]);
    figFwdVsFbk = figure('Position', [20, 220, 1200, 330]);

    for infoIdx = 1:numel(params.info_type)
        infoLab = params.info_type{infoIdx};

        tmpNetwork = sessConnStrenghts.all.(infoLab).(params.band_label);
        tmpNetwork = tmpNetwork(:,sort_idxs,sort_idxs); % reorder links according to hierarchy
        clear p abs_dir_net sig_dir_net sig_dir_net

        sig_dir_net = zeros(size(tmpNetwork,3),size(tmpNetwork,3));
        abs_dir_net = zeros(size(tmpNetwork,3),size(tmpNetwork,3));

        for roi1 = 1:size(tmpNetwork,3)
            for roi2 = roi1+1:size(tmpNetwork,3)
                fwdTransf = squeeze(tmpNetwork(:,roi1,roi2));
                fbkTransf = squeeze(tmpNetwork(:,roi2,roi1));
                [~,p(roi1,roi2)] = ttest(fwdTransf,fbkTransf);

                tmpDir = mean(fwdTransf-fbkTransf);
                if tmpDir >= 0
                    abs_dir_net(roi1,roi2) = 1;
                else
                    abs_dir_net(roi2,roi1) = 1;
                end

                if p(roi1,roi2) < 0.05
                    sig_dir_net(roi1,roi2) = abs_dir_net(roi1,roi2);
                    sig_dir_net(roi2,roi1) = abs_dir_net(roi2,roi1);
                end

                fwd_vs_fbk(roi1,roi2) = mean(fwdTransf-fbkTransf);
                fwd_vs_fbk(roi2,roi1) = mean(fwdTransf-fbkTransf);
            end
        end

        figure(figAll)
        subplot(1,3,infoIdx)

        G=staticNetworks.all.(infoLab).(params.band_label);
        G = reordernodes(G,sort_idxs); 
        static_network_plot_v4(G,computedROIsCols);
        title([infoLab])


        figure(figAbs)
        subplot(1,3,infoIdx)

        abs_dir_net = abs_dir_net'; % traspose to then linearize correctly
        sig_dir_net = sig_dir_net'; % traspose to then linearize correctly

        rmAbs = ~abs_dir_net(:);% Idxs of links to remove according to absolute directionality
        rmAbs(1:size(abs_dir_net,1)+1:numel(abs_dir_net(:))) = []; % remove diagonal elements (not links in the network)
        G=staticNetworks.all.(infoLab).(params.band_label);
        G = reordernodes(G,sort_idxs); 
        G = rmedge(G,find(rmAbs));
        static_network_plot_v2(G,computedROIsCols);
        title([infoLab])


        figure(figSig)
        subplot(1,3,infoIdx)

        rmSig = ~sig_dir_net(:);% Idxs of links to remove according to absolute directionality
        rmSig(1:size(sig_dir_net,1)+1:numel(sig_dir_net(:))) = []; % remove diagonal elements (not links in the network)
        G=staticNetworks.all.(infoLab).(params.band_label);
        G = reordernodes(G,sort_idxs); 
        G = rmedge(G,find(rmSig));
        static_network_plot_v2(G,computedROIsCols);
        title([infoLab])

        figure(figFwdVsFbk)
        subplot(1,3,infoIdx)

        imagesc(fwd_vs_fbk)
        set(gca, 'XTick',1:numel(computedROIs), 'XTickLabel', ROIs_label(sort_idxs),'FontSize',fSize)
        set(gca, 'YTick',1:numel(computedROIs), 'YTickLabel', ROIs_label(sort_idxs),'FontSize',fSize)
        colormap(bluewhitered(256))
        c=colorbar();
        c.Label.String = 'forward-feedback [bits]';
        title([infoLab])
    end

    figure(figAbs)
    sgtitle(['Net directionality networks'])
    if params.save_figures
        fname = [paths.figuresPath,'\graph_netDir_',params.across_subj_method,'_',date,'.png'];
        saveas(figAbs,fname)
        fname = [paths.figuresPath,'\graph_netDir_',params.across_subj_method,'_',date,'.fig'];
        saveas(figAbs,fname)
        fname = [paths.figuresPath,'\graph_netDir_',params.across_subj_method,'_',date,'.svg'];
        figAbs.Renderer = 'painters';
        saveas(figAbs,fname)
    end

    figure(figAll)
    sgtitle(['All links directionality networks'])
    if params.save_figures
        fname = [paths.figuresPath,'\graph_allDir_',params.across_subj_method,'_',date,'.png'];
        saveas(figAll,fname)
        fname = [paths.figuresPath,'\graph_allDir_',params.across_subj_method,'_',date,'fig'];
        saveas(figAll,fname)
        fname = [paths.figuresPath,'\graph_allDir_',params.across_subj_method,'_',date,'.svg'];
        figAll.Renderer = 'painters';
        saveas(figAll,fname)
    end

    figure(figSig)
    sgtitle(['Significant directionality networks'])
    if params.save_figures
        fname = [paths.figuresPath,'\graph_sigDir_',params.across_subj_method,'_',date,'.png'];
        saveas(figSig,fname)
        fname = [paths.figuresPath,'\graph_sigDir_',params.across_subj_method,'_',date,'.fig'];
        saveas(figSig,fname)
        fname = [paths.figuresPath,'\graph_sigDir_',params.across_subj_method,'_',date,'.svg'];
        figSig.Renderer = 'painters';
        saveas(figSig,fname)
    end

    figure(figFwdVsFbk)
    sgtitle(['Forward vs feedback networks'])
    if params.save_figures
        fname = [paths.figuresPath,'\graph_FwdVsFbk_',params.across_subj_method,'_',date,'.png'];
        saveas(figFwdVsFbk,fname)
        fname = [paths.figuresPath,'\graph_FwdVsFbk_',params.across_subj_method,'_',date,'.fig'];
        saveas(figFwdVsFbk,fname)
        fname = [paths.figuresPath,'\graph_FwdVsFbk_',params.across_subj_method,'_',date,'.svg'];
        figFwdVsFbk.Renderer = 'painters';
        saveas(figFwdVsFbk,fname)
    end
end

end

