function [deltaDI_td_map] = plot_time_delay_maps_visNet_deltaDI(timeDelayMaps,computedROIs,sort_idxs,plot_times,plot_pair,params,paths)
%  adapted to bootstrap method for nullhyp

delays = [params.minSelDelay*16.7:16.7:params.maxSelDelay*16.7];


[deltaDI_td_map] = time_delay_groupsPairs_visNet_deltaDI(timeDelayMaps, 'deltaDI', 'band_40_75', computedROIs, sort_idxs, params);
maxY{1} = max(max([deltaDI_td_map.all.(plot_pair).forward'; deltaDI_td_map.all.(plot_pair).feedback']));

fig=figure('Position',[360,400,814,218]);
% deltaDI
subplot(1,2,1)
imagesc(plot_times,delays,deltaDI_td_map.all.(plot_pair).forward')
title(['deltaDI, feedforward'])
colorbar();
xlabel('time of the receiver [ms]')
ylabel('delay [ms]')
caxis([0,maxY{1}]);
subplot(1,2,2)
imagesc(plot_times,delays,deltaDI_td_map.all.(plot_pair).feedback')
title(['deltaDI, feedback'])
colorbar();
caxis([0,maxY{1}]);
xlabel('time of the receiver [ms]')
ylabel('delay [ms]')

sgtitle(['Time-delay maps, average across all regions pairs in gamma'])

if params.save_figures
    fname = [paths.figuresPath,'\visNet_deltaDI_TD_maps_',date,'.png'];
    saveas(fig,fname)
    fname = [paths.figuresPath,'\visNet_deltaDI_TD_maps_',date,'.fig'];
    saveas(fig,fname)
    fname = [paths.figuresPath,'\visNet_deltaDI_TD_maps_',date,'.svg'];
    fig.Renderer = 'painters';
    saveas(fig,fname)
end

end