function plot_time_delay_profiles_visNet_v1(FIT_td_map,DI_td_map,plot_times,plot_pair,params)

delays = [params.minSelDelay*16.7:16.7:params.maxSelDelay*16.7];
plot_delays = delays;

% All trials
% Plot time profiles
figure()
subplot(1,2,1)
hold on
meanDI = mean(DI_td_map.all.(plot_pair).forward,2); % not taking params.minSelDelay:params.maxSelDelay because TD maps are already pre-computed in that interval
%semDI = std(DI_td_map.(plot_pair).forward,2);
plot(plot_times,meanDI,'b')
meanDI = mean(DI_td_map.all.(plot_pair).feedback,2);
plot(plot_times,meanDI,'r')
legend('Feedforward','Feedback')
xlim([plot_times(1),plot_times(end)])
xlabel('Time [ms]')
title('DI')

subplot(1,2,2)
hold on
meanFIT = mean(FIT_td_map.all.(plot_pair).forward,2);
plot(plot_times,meanFIT,'b')
meanFIT = mean(FIT_td_map.all.(plot_pair).feedback,2);
plot(plot_times,meanFIT,'r')
legend('Feedforward','Feedback')
title('FIT_S')
xlim([plot_times(1),plot_times(end)])
xlabel('Time [ms]')
sgtitle('Time profiles')

% All trials
% Plot delays profiles
figure()
subplot(1,2,1)
hold on
meanDI = mean(DI_td_map.all.(plot_pair).forward,1);
%semDI = std(DI_td_map.(plot_pair).forward,2);
plot(plot_delays,meanDI,'b')
meanDI = mean(DI_td_map.all.(plot_pair).feedback,1);
plot(plot_delays,meanDI,'r')
legend('Feedforward','Feedback')
xlim([plot_delays(1),plot_delays(end)])
xlabel('Delay [ms]')
title('DI')

subplot(1,2,2)
hold on
meanFIT = mean(FIT_td_map.all.(plot_pair).forward,1);
plot(plot_delays,meanFIT,'b')
meanFIT = mean(FIT_td_map.all.(plot_pair).feedback,1);
plot(plot_delays,meanFIT,'r')
legend('Feedforward','Feedback')
xlim([plot_delays(1),plot_delays(end)])
xlabel('Delay [ms]')
title('FIT_S')
sgtitle('Delay profiles')

% Corr vs err feedforward
% Time profiles
figure()
subplot(1,2,1)
hold on
meanDI = mean(DI_td_map.corr.(plot_pair).forward,2);
%semDI = std(DI_td_map.(plot_pair).forward,2);
plot(plot_times,meanDI,'g')
meanDI = mean(DI_td_map.err.(plot_pair).forward,2);
plot(plot_times,meanDI,'Color',[0.6,0.6,0.6])
legend('Correct','Error')
xlim([plot_times(1),plot_times(end)])
xlabel('Time [ms]')
title('DI')

subplot(1,2,2)
hold on
meanFIT = mean(FIT_td_map.corr.(plot_pair).forward,2);
plot(plot_times,meanFIT,'g')
meanFIT = mean(FIT_td_map.err.(plot_pair).forward,2);
plot(plot_times,meanFIT,'Color',[0.6,0.6,0.6])
legend('Correct','Error')
title('FIT_S')
xlim([plot_times(1),plot_times(end)])
xlabel('Time [ms]')
sgtitle('Time profiles')

% All trials
% Plot delays profiles
figure()
subplot(1,2,1)
hold on
meanDI = mean(DI_td_map.corr.(plot_pair).forward,1);
%semDI = std(DI_td_map.(plot_pair).forward,2);
plot(plot_delays,meanDI,'g')
meanDI = mean(DI_td_map.err.(plot_pair).forward,1);
plot(plot_delays,meanDI,'Color',[0.6,0.6,0.6])
xlim([plot_delays(1),plot_delays(end)])
xlabel('Delay [ms]')
title('DI')

subplot(1,2,2)
hold on
meanFIT = mean(FIT_td_map.corr.(plot_pair).forward,1);
plot(plot_delays,meanFIT,'g')
meanFIT = mean(FIT_td_map.err.(plot_pair).forward,1);
plot(plot_delays,meanFIT,'Color',[0.6,0.6,0.6])
xlim([plot_delays(1),plot_delays(end)])
xlabel('Delay [ms]')
title('FIT_S')
sgtitle('Delay profiles')

end