function [MaxMarg1, MaxMarg2, MaxMarg3, MaxMarg4] = computeBoxes(InfoMat, InfoMat2, area1, area2, YLIM, Panel)
  
stim2 = 1;
stims_names = {'V+T', 'CV+IT', 'IV+CT','IV+IT', 'T', 'IT', 'V', 'IV', 'NS'};
areas_names = {'LGN', 'V1', 'V1G', 'V1S', 'VPM', 'S1', 'S1G', 'S1S'};

if area1 == 5
    STIM_SET = [5,1];
elseif area1 == 1
    STIM_SET = [7,1];
end
STIM1_LIST = [7,5];
stim1_1 = STIM1_LIST(1);
stim1_2 = STIM1_LIST(2);
name_area1 = areas_names{area1};
name_area2 = areas_names{area2};
name_stim1_1 = stims_names{stim1_1};
name_stim1_2 = stims_names{stim1_2};
name_stim2 = stims_names{stim2};

h = figure;
h.Position = [360,198,727.7,320];

if Panel == 1
    if area1 == 1
        MaxMarg1(1) = max(squeeze(mean(squeeze(InfoMat(1,area1,area2,stim1_1,stim2,8:9,9:10,1)),1)),[],2);
        MaxMarg1(2) = max(squeeze(mean(squeeze(InfoMat(2,area1,area2,stim1_1,stim2,8:9,14:16,1)),1)),[],2);
        MaxMarg1(3) = max(squeeze(mean(squeeze(InfoMat(3,area1,area2,stim1_1,stim2,18:19,15:16,1)),1)),[],2);
        MaxMarg1(4) = max(squeeze(mean(squeeze(InfoMat(4,area1,area2,stim1_1,stim2,11:12,10:13,1)),1)),[],2);
        MaxMarg1(5) = max(squeeze(mean(squeeze(InfoMat(5,area1,area2,stim1_1,stim2,23:24,13:14,1)),1)),[],2);
        MaxMarg1(6) = max(squeeze(mean(squeeze(InfoMat(6,area1,area2,stim1_1,stim2,6:7,11:12,1)),1)),[],2);

        MaxMarg2(1) = max(squeeze(mean(squeeze(InfoMat(1,area1,area2,stim1_2,stim2,8:9,9:10,1)),1)),[],2);
        MaxMarg2(2) = max(squeeze(mean(squeeze(InfoMat(2,area1,area2,stim1_2,stim2,8:9,14:16,1)),1)),[],2);
        MaxMarg2(3) = max(squeeze(mean(squeeze(InfoMat(3,area1,area2,stim1_2,stim2,18:19,15:16,1)),1)),[],2);
        MaxMarg2(4) = max(squeeze(mean(squeeze(InfoMat(4,area1,area2,stim1_2,stim2,11:12,10:13,1)),1)),[],2);
        MaxMarg2(5) = max(squeeze(mean(squeeze(InfoMat(5,area1,area2,stim1_2,stim2,23:24,13:14,1)),1)),[],2);
        MaxMarg2(6) = max(squeeze(mean(squeeze(InfoMat(6,area1,area2,stim1_2,stim2,6:7,11:12,1)),1)),[],2);

        MaxMarg3(1) = max(squeeze(mean(squeeze(InfoMat(1,area2,area1,stim1_1,stim2,8:9,9:10,1)),1)),[],2);
        MaxMarg3(2) = max(squeeze(mean(squeeze(InfoMat(2,area2,area1,stim1_1,stim2,8:9,14:16,1)),1)),[],2);
        MaxMarg3(3) = max(squeeze(mean(squeeze(InfoMat(3,area2,area1,stim1_1,stim2,18:19,15:16,1)),1)),[],2);
        MaxMarg3(4) = max(squeeze(mean(squeeze(InfoMat(4,area2,area1,stim1_1,stim2,11:12,10:13,1)),1)),[],2);
        MaxMarg3(5) = max(squeeze(mean(squeeze(InfoMat(5,area2,area1,stim1_1,stim2,23:24,13:14,1)),1)),[],2);
        MaxMarg3(6) = max(squeeze(mean(squeeze(InfoMat(6,area2,area1,stim1_1,stim2,6:7,11:12,1)),1)),[],2);
   
        MaxMarg4(1) = max(squeeze(mean(squeeze(InfoMat(1,area2,area1,stim1_2,stim2,8:9,9:10,1)),1)),[],2);
        MaxMarg4(2) = max(squeeze(mean(squeeze(InfoMat(2,area2,area1,stim1_2,stim2,8:9,14:16,1)),1)),[],2);
        MaxMarg4(3) = max(squeeze(mean(squeeze(InfoMat(3,area2,area1,stim1_2,stim2,18:19,15:16,1)),1)),[],2);
        MaxMarg4(4) = max(squeeze(mean(squeeze(InfoMat(4,area2,area1,stim1_2,stim2,11:12,10:13,1)),1)),[],2);
        MaxMarg4(5) = max(squeeze(mean(squeeze(InfoMat(5,area2,area1,stim1_2,stim2,23:24,13:14,1)),1)),[],2);
        MaxMarg4(6) = max(squeeze(mean(squeeze(InfoMat(6,area2,area1,stim1_2,stim2,6:7,11:12,1)),1)),[],2);
   
    elseif area1 == 5  
        MaxMarg1(1) = max(squeeze(mean(squeeze(InfoMat(1,area1,area2,stim1_1,stim2,2:3,4:5,1)),1)),[],2);
        MaxMarg1(2) = max(squeeze(mean(squeeze(InfoMat(2,area1,area2,stim1_1,stim2,4:5,5:6,1)),1)),[],2);
        MaxMarg1(3) = max(squeeze(mean(squeeze(InfoMat(3,area1,area2,stim1_1,stim2,3:6,5:6,1)),1)),[],2);
        MaxMarg1(4) = max(squeeze(mean(squeeze(InfoMat(4,area1,area2,stim1_1,stim2,3:6,6:7,1)),1)),[],2);
        MaxMarg1(5) = max(squeeze(mean(squeeze(InfoMat(5,area1,area2,stim1_1,stim2,3:4,5:6,1)),1)),[],2);
        MaxMarg1(6) = max(squeeze(mean(squeeze(InfoMat(6,area1,area2,stim1_1,stim2,6:7,4:5,1)),1)),[],2);

        MaxMarg2(1) = max(squeeze(mean(squeeze(InfoMat(1,area1,area2,stim1_2,stim2,2:3,4:5,1)),1)),[],2);
        MaxMarg2(2) = max(squeeze(mean(squeeze(InfoMat(2,area1,area2,stim1_2,stim2,4:5,5:6,1)),1)),[],2);
        MaxMarg2(3) = max(squeeze(mean(squeeze(InfoMat(3,area1,area2,stim1_2,stim2,3:6,5:6,1)),1)),[],2);
        MaxMarg2(4) = max(squeeze(mean(squeeze(InfoMat(4,area1,area2,stim1_2,stim2,3:6,6:7,1)),1)),[],2);
        MaxMarg2(5) = max(squeeze(mean(squeeze(InfoMat(5,area1,area2,stim1_2,stim2,3:4,5:6,1)),1)),[],2);
        MaxMarg2(6) = max(squeeze(mean(squeeze(InfoMat(6,area1,area2,stim1_2,stim2,6:7,4:5,1)),1)),[],2);

        MaxMarg3(1) = max(squeeze(mean(squeeze(InfoMat(1,area2,area1,stim1_1,stim2,2:3,4:5,1)),1)),[],2);
        MaxMarg3(2) = max(squeeze(mean(squeeze(InfoMat(2,area2,area1,stim1_1,stim2,4:5,5:6,1)),1)),[],2);
        MaxMarg3(3) = max(squeeze(mean(squeeze(InfoMat(3,area2,area1,stim1_1,stim2,3:6,5:6,1)),1)),[],2);
        MaxMarg3(4) = max(squeeze(mean(squeeze(InfoMat(4,area2,area1,stim1_1,stim2,3:6,6:7,1)),1)),[],2);
        MaxMarg3(5) = max(squeeze(mean(squeeze(InfoMat(5,area2,area1,stim1_1,stim2,3:4,5:6,1)),1)),[],2);
        MaxMarg3(6) = max(squeeze(mean(squeeze(InfoMat(6,area2,area1,stim1_1,stim2,6:7,4:5,1)),1)),[],2);

        MaxMarg4(1) = max(squeeze(mean(squeeze(InfoMat(1,area2,area1,stim1_2,stim2,2:3,4:5,1)),1)),[],2);
        MaxMarg4(2) = max(squeeze(mean(squeeze(InfoMat(2,area2,area1,stim1_2,stim2,4:5,5:6,1)),1)),[],2);
        MaxMarg4(3) = max(squeeze(mean(squeeze(InfoMat(3,area2,area1,stim1_2,stim2,3:6,5:6,1)),1)),[],2);
        MaxMarg4(4) = max(squeeze(mean(squeeze(InfoMat(4,area2,area1,stim1_2,stim2,3:6,6:7,1)),1)),[],2);
        MaxMarg4(5) = max(squeeze(mean(squeeze(InfoMat(5,area2,area1,stim1_2,stim2,3:4,5:6,1)),1)),[],2);
        MaxMarg4(6) = max(squeeze(mean(squeeze(InfoMat(6,area2,area1,stim1_2,stim2,6:7,4:5,1)),1)),[],2);
    end
    
%     sgtitle([name_area1,'\rightarrow',name_area2],'FontSize',18);  
    
    M1 = mean(MaxMarg1);
    S1 = std(MaxMarg1)./sqrt(length(mean(MaxMarg1)));
    MaxMargPlot1 = [M1-S1, M1, M1+S1]';    
    M2 = mean(MaxMarg2);
    S2 = std(MaxMarg2)./sqrt(length(mean(MaxMarg2)));
    MaxMargPlot2 = [M2-S2, M2, M2+S2]';   
    M3 = mean(MaxMarg3);
    S3 = std(MaxMarg3)./sqrt(length(mean(MaxMarg3)));
    MaxMargPlot3 = [M3-S3, M3, M3+S3]';
    M4 = mean(MaxMarg4);
    S4 = std(MaxMarg4)./sqrt(length(mean(MaxMarg4)));
    MaxMargPlot4 = [M4-S4, M4, M4+S4]';
    
    subplot(1,2,1);
%     boxplot([MaxMargPlot1 MaxMargPlot2], 'Colors', 'rb', 'Symbol', 'g+');
    hold on
    errorbar(1.25, M1,S1,'o','Color', 'red', 'LineWidth', 3, 'MarkerFaceColor','red', 'MarkerSize', 10);
    errorbar(1.75, M2,S2,'o','Color', 'blue', 'LineWidth', 3, 'MarkerFaceColor','blue', 'MarkerSize', 10);
    xlim([1, 2])
    if YLIM(2)>0, ylim(YLIM), end

    [~,p2] = ttest(MaxMarg1,MaxMarg2);
%     p2(p2 > 0.05) = NaN;
    sigstar({[1.25,1.75]},p2,YLIM(2));
    
%     set(gca, 'XTickLabel', {['{',stims_names{stim1_1},',',stims_names{stim2},'}'], ['{',stims_names{stim1_2},',',stims_names{stim2},'}']});
    xticks([1.25, 1.75])
    set(gca, 'XTickLabel', {'Tactile', 'Visual'});
    
    set(gca,'FontSize',18);
    set(gca,'linewidth',2);
    set(gca,'Box','on')
    ylabel('(bits)')
    set(gca, 'YTickLabel', get(gca, 'YTick'));
    set(findobj(gca,'type','line'),'linew',2)
    title(['DI: ',name_area1,'\rightarrow',name_area2],'FontSize',12);  
    
%     set(gca,'OuterPosition',[0.069,0.011,0.40,0.89]);
%     set(gca,'InnerPosition',[0.19,0.11,0.27,0.72]);
    subplot(1,2,2);
    hold on
    errorbar(1.25, M3,S3,'o','Color', [50, 201, 199]/255, 'LineWidth', 3, 'MarkerFaceColor',[50, 201, 199]/255, 'MarkerSize', 10);
    errorbar(1.75, M4,S4,'o','Color', [144, 40, 158]/255, 'LineWidth', 3, 'MarkerFaceColor',[144, 40, 158]/255, 'MarkerSize', 10);
    xlim([1, 2])
    if YLIM(2)>0, ylim(YLIM), end

    [~,p2] = ttest(MaxMarg3,MaxMarg4);
%     p2(p2 > 0.05) = NaN;
    sigstar({[1.25,1.75]},p2,YLIM(2));
    
%     set(gca, 'XTickLabel', {['{',stims_names{stim1_1},',',stims_names{stim2},'}'], ['{',stims_names{stim1_2},',',stims_names{stim2},'}']});
    xticks([1.25, 1.75])
    set(gca, 'XTickLabel', {'Tactile', 'Visual'});
    
    set(gca,'FontSize',18);
    set(gca,'linewidth',2);
    set(gca,'Box','on')
    ylabel('(bits)')
    set(gca, 'YTickLabel', get(gca, 'YTick'));
    set(findobj(gca,'type','line'),'linew',2);
    title(['DI: ',name_area2,'\rightarrow',name_area1],'FontSize',12);  
    
    g = figure;
    g.Position = [360,198,727.7,320];
    if area1 == 1
        MaxMarg1(1) = max(squeeze(mean(squeeze(InfoMat2(1,area1,area2,stim1_1,stim2,8:9,9:10,1)),1)),[],2);
        MaxMarg1(2) = max(squeeze(mean(squeeze(InfoMat2(2,area1,area2,stim1_1,stim2,8:9,14:16,1)),1)),[],2);
        MaxMarg1(3) = max(squeeze(mean(squeeze(InfoMat2(3,area1,area2,stim1_1,stim2,18:19,15:16,1)),1)),[],2);
        MaxMarg1(4) = max(squeeze(mean(squeeze(InfoMat2(4,area1,area2,stim1_1,stim2,11:12,10:13,1)),1)),[],2);
        MaxMarg1(5) = max(squeeze(mean(squeeze(InfoMat2(5,area1,area2,stim1_1,stim2,23:24,13:14,1)),1)),[],2);
        MaxMarg1(6) = max(squeeze(mean(squeeze(InfoMat2(6,area1,area2,stim1_1,stim2,6:7,11:12,1)),1)),[],2);

        MaxMarg2(1) = max(squeeze(mean(squeeze(InfoMat2(1,area1,area2,stim1_2,stim2,8:9,9:10,1)),1)),[],2);
        MaxMarg2(2) = max(squeeze(mean(squeeze(InfoMat2(2,area1,area2,stim1_2,stim2,8:9,14:16,1)),1)),[],2);
        MaxMarg2(3) = max(squeeze(mean(squeeze(InfoMat2(3,area1,area2,stim1_2,stim2,18:19,15:16,1)),1)),[],2);
        MaxMarg2(4) = max(squeeze(mean(squeeze(InfoMat2(4,area1,area2,stim1_2,stim2,11:12,10:13,1)),1)),[],2);
        MaxMarg2(5) = max(squeeze(mean(squeeze(InfoMat2(5,area1,area2,stim1_2,stim2,23:24,13:14,1)),1)),[],2);
        MaxMarg2(6) = max(squeeze(mean(squeeze(InfoMat2(6,area1,area2,stim1_2,stim2,6:7,11:12,1)),1)),[],2);

        MaxMarg3(1) = max(squeeze(mean(squeeze(InfoMat2(1,area2,area1,stim1_1,stim2,8:9,9:10,1)),1)),[],2);
        MaxMarg3(2) = max(squeeze(mean(squeeze(InfoMat2(2,area2,area1,stim1_1,stim2,8:9,14:16,1)),1)),[],2);
        MaxMarg3(3) = max(squeeze(mean(squeeze(InfoMat2(3,area2,area1,stim1_1,stim2,18:19,15:16,1)),1)),[],2);
        MaxMarg3(4) = max(squeeze(mean(squeeze(InfoMat2(4,area2,area1,stim1_1,stim2,11:12,10:13,1)),1)),[],2);
        MaxMarg3(5) = max(squeeze(mean(squeeze(InfoMat2(5,area2,area1,stim1_1,stim2,23:24,13:14,1)),1)),[],2);
        MaxMarg3(6) = max(squeeze(mean(squeeze(InfoMat2(6,area2,area1,stim1_1,stim2,6:7,11:12,1)),1)),[],2);
   
        MaxMarg4(1) = max(squeeze(mean(squeeze(InfoMat2(1,area2,area1,stim1_2,stim2,8:9,9:10,1)),1)),[],2);
        MaxMarg4(2) = max(squeeze(mean(squeeze(InfoMat2(2,area2,area1,stim1_2,stim2,8:9,14:16,1)),1)),[],2);
        MaxMarg4(3) = max(squeeze(mean(squeeze(InfoMat2(3,area2,area1,stim1_2,stim2,18:19,15:16,1)),1)),[],2);
        MaxMarg4(4) = max(squeeze(mean(squeeze(InfoMat2(4,area2,area1,stim1_2,stim2,11:12,10:13,1)),1)),[],2);
        MaxMarg4(5) = max(squeeze(mean(squeeze(InfoMat2(5,area2,area1,stim1_2,stim2,23:24,13:14,1)),1)),[],2);
        MaxMarg4(6) = max(squeeze(mean(squeeze(InfoMat2(6,area2,area1,stim1_2,stim2,6:7,11:12,1)),1)),[],2);
   
    elseif area1 == 5  
        MaxMarg1(1) = max(squeeze(mean(squeeze(InfoMat2(1,area1,area2,stim1_1,stim2,2:3,4:5,1)),1)),[],2);
        MaxMarg1(2) = max(squeeze(mean(squeeze(InfoMat2(2,area1,area2,stim1_1,stim2,4:5,5:6,1)),1)),[],2);
        MaxMarg1(3) = max(squeeze(mean(squeeze(InfoMat2(3,area1,area2,stim1_1,stim2,3:6,5:6,1)),1)),[],2);
        MaxMarg1(4) = max(squeeze(mean(squeeze(InfoMat2(4,area1,area2,stim1_1,stim2,3:6,6:7,1)),1)),[],2);
        MaxMarg1(5) = max(squeeze(mean(squeeze(InfoMat2(5,area1,area2,stim1_1,stim2,3:4,5:6,1)),1)),[],2);
        MaxMarg1(6) = max(squeeze(mean(squeeze(InfoMat2(6,area1,area2,stim1_1,stim2,6:7,4:5,1)),1)),[],2);

        MaxMarg2(1) = max(squeeze(mean(squeeze(InfoMat2(1,area1,area2,stim1_2,stim2,2:3,4:5,1)),1)),[],2);
        MaxMarg2(2) = max(squeeze(mean(squeeze(InfoMat2(2,area1,area2,stim1_2,stim2,4:5,5:6,1)),1)),[],2);
        MaxMarg2(3) = max(squeeze(mean(squeeze(InfoMat2(3,area1,area2,stim1_2,stim2,3:6,5:6,1)),1)),[],2);
        MaxMarg2(4) = max(squeeze(mean(squeeze(InfoMat2(4,area1,area2,stim1_2,stim2,3:6,6:7,1)),1)),[],2);
        MaxMarg2(5) = max(squeeze(mean(squeeze(InfoMat2(5,area1,area2,stim1_2,stim2,3:4,5:6,1)),1)),[],2);
        MaxMarg2(6) = max(squeeze(mean(squeeze(InfoMat2(6,area1,area2,stim1_2,stim2,6:7,4:5,1)),1)),[],2);

        MaxMarg3(1) = max(squeeze(mean(squeeze(InfoMat2(1,area2,area1,stim1_1,stim2,2:3,4:5,1)),1)),[],2);
        MaxMarg3(2) = max(squeeze(mean(squeeze(InfoMat2(2,area2,area1,stim1_1,stim2,4:5,5:6,1)),1)),[],2);
        MaxMarg3(3) = max(squeeze(mean(squeeze(InfoMat2(3,area2,area1,stim1_1,stim2,3:6,5:6,1)),1)),[],2);
        MaxMarg3(4) = max(squeeze(mean(squeeze(InfoMat2(4,area2,area1,stim1_1,stim2,3:6,6:7,1)),1)),[],2);
        MaxMarg3(5) = max(squeeze(mean(squeeze(InfoMat2(5,area2,area1,stim1_1,stim2,3:4,5:6,1)),1)),[],2);
        MaxMarg3(6) = max(squeeze(mean(squeeze(InfoMat2(6,area2,area1,stim1_1,stim2,6:7,4:5,1)),1)),[],2);

        MaxMarg4(1) = max(squeeze(mean(squeeze(InfoMat2(1,area2,area1,stim1_2,stim2,2:3,4:5,1)),1)),[],2);
        MaxMarg4(2) = max(squeeze(mean(squeeze(InfoMat2(2,area2,area1,stim1_2,stim2,4:5,5:6,1)),1)),[],2);
        MaxMarg4(3) = max(squeeze(mean(squeeze(InfoMat2(3,area2,area1,stim1_2,stim2,3:6,5:6,1)),1)),[],2);
        MaxMarg4(4) = max(squeeze(mean(squeeze(InfoMat2(4,area2,area1,stim1_2,stim2,3:6,6:7,1)),1)),[],2);
        MaxMarg4(5) = max(squeeze(mean(squeeze(InfoMat2(5,area2,area1,stim1_2,stim2,3:4,5:6,1)),1)),[],2);
        MaxMarg4(6) = max(squeeze(mean(squeeze(InfoMat2(6,area2,area1,stim1_2,stim2,6:7,4:5,1)),1)),[],2);
    end
    
%     sgtitle([name_area1,'\rightarrow',name_area2],'FontSize',18);  
    
    M1 = mean(MaxMarg1);
    S1 = std(MaxMarg1)./sqrt(length(mean(MaxMarg1)));
    MaxMargPlot1 = [M1-S1, M1, M1+S1]';    
    M2 = mean(MaxMarg2);
    S2 = std(MaxMarg2)./sqrt(length(mean(MaxMarg2)));
    MaxMargPlot2 = [M2-S2, M2, M2+S2]';   
    M3 = mean(MaxMarg3);
    S3 = std(MaxMarg3)./sqrt(length(mean(MaxMarg3)));
    MaxMargPlot3 = [M3-S3, M3, M3+S3]';
    M4 = mean(MaxMarg4);
    S4 = std(MaxMarg4)./sqrt(length(mean(MaxMarg4)));
    MaxMargPlot4 = [M4-S4, M4, M4+S4]';
    
    subplot(1,2,1);
%     boxplot([MaxMargPlot1 MaxMargPlot2], 'Colors', 'rb', 'Symbol', 'g+');
    hold on
    errorbar(1.25, M1,S1,'o','Color', 'red', 'LineWidth', 3, 'MarkerFaceColor','red', 'MarkerSize', 10);
    errorbar(1.75, M2,S2,'o','Color', 'blue', 'LineWidth', 3, 'MarkerFaceColor','blue', 'MarkerSize', 10);
    xlim([1, 2])
    if YLIM(2)>0, ylim(YLIM), end

    [~,p2] = ttest(MaxMarg1,MaxMarg2);
%     p2(p2 > 0.05) = NaN;
    sigstar({[1.25,1.75]},p2,YLIM(2));
    
%     set(gca, 'XTickLabel', {['{',stims_names{stim1_1},',',stims_names{stim2},'}'], ['{',stims_names{stim1_2},',',stims_names{stim2},'}']});
    xticks([1.25, 1.75])
    set(gca, 'XTickLabel', {'Tactile', 'Visual'});
    
    set(gca,'FontSize',18);
    set(gca,'linewidth',2);
    set(gca,'Box','on')
    ylabel('(bits)')
    set(gca, 'YTickLabel', get(gca, 'YTick'));
    set(findobj(gca,'type','line'),'linew',2)
    title(['FIT: ',name_area1,'\rightarrow',name_area2],'FontSize',12);  
    
%     set(gca,'OuterPosition',[0.069,0.011,0.40,0.89]);
%     set(gca,'InnerPosition',[0.19,0.11,0.27,0.72]);
    subplot(1,2,2);
    hold on
    errorbar(1.25, M3,S3,'o','Color', [50, 201, 199]/255, 'LineWidth', 3, 'MarkerFaceColor',[50, 201, 199]/255, 'MarkerSize', 10);
    errorbar(1.75, M4,S4,'o','Color', [144, 40, 158]/255, 'LineWidth', 3, 'MarkerFaceColor',[144, 40, 158]/255, 'MarkerSize', 10);
    xlim([1, 2])
    if YLIM(2)>0, ylim(YLIM), end

    [~,p2] = ttest(MaxMarg3,MaxMarg4);
%     p2(p2 > 0.05) = NaN;
    sigstar({[1.25,1.75]},p2,YLIM(2));
    
%     set(gca, 'XTickLabel', {['{',stims_names{stim1_1},',',stims_names{stim2},'}'], ['{',stims_names{stim1_2},',',stims_names{stim2},'}']});
    xticks([1.25, 1.75])
    set(gca, 'XTickLabel', {'Tactile', 'Visual'});
    
    set(gca,'FontSize',18);
    set(gca,'linewidth',2);
    set(gca,'Box','on')
    ylabel('(bits)')
    set(gca, 'YTickLabel', get(gca, 'YTick'));
    set(findobj(gca,'type','line'),'linew',2);
    title(['FIT: ',name_area2,'\rightarrow',name_area1],'FontSize',12);

elseif Panel == 2
    
    
        if area1 == 1
            sstim = stim1_2;

            MaxMarg1(1) = max(squeeze(mean(squeeze(InfoMat(1,area1,area2,sstim,stim2,8:9,9:10,1)),1)),[],2);
            MaxMarg1(2) = max(squeeze(mean(squeeze(InfoMat(2,area1,area2,sstim,stim2,8:9,14:16,1)),1)),[],2);
            MaxMarg1(3) = max(squeeze(mean(squeeze(InfoMat(3,area1,area2,sstim,stim2,18:19,15:16,1)),1)),[],2);
            MaxMarg1(4) = max(squeeze(mean(squeeze(InfoMat(4,area1,area2,sstim,stim2,11:12,10:13,1)),1)),[],2);
            MaxMarg1(5) = max(squeeze(mean(squeeze(InfoMat(5,area1,area2,sstim,stim2,23:24,13:14,1)),1)),[],2);
            MaxMarg1(6) = max(squeeze(mean(squeeze(InfoMat(6,area1,area2,sstim,stim2,6:7,11:12,1)),1)),[],2);

            MaxMarg2(1) = max(squeeze(mean(squeeze(InfoMat(1,area2,area1,sstim,stim2,8:9,9:10,1)),1)),[],2);
            MaxMarg2(2) = max(squeeze(mean(squeeze(InfoMat(2,area2,area1,sstim,stim2,8:9,14:16,1)),1)),[],2);
            MaxMarg2(3) = max(squeeze(mean(squeeze(InfoMat(3,area2,area1,sstim,stim2,18:19,15:16,1)),1)),[],2);
            MaxMarg2(4) = max(squeeze(mean(squeeze(InfoMat(4,area2,area1,sstim,stim2,11:12,10:13,1)),1)),[],2);
            MaxMarg2(5) = max(squeeze(mean(squeeze(InfoMat(5,area2,area1,sstim,stim2,23:24,13:14,1)),1)),[],2);
            MaxMarg2(6) = max(squeeze(mean(squeeze(InfoMat(6,area2,area1,sstim,stim2,6:7,11:12,1)),1)),[],2);

            MaxMarg3(1) = max(squeeze(mean(squeeze(InfoMat2(1,area1,area2,sstim,stim2,8:9,9:10,1)),1)),[],2);
            MaxMarg3(2) = max(squeeze(mean(squeeze(InfoMat2(2,area1,area2,sstim,stim2,8:9,14:16,1)),1)),[],2);
            MaxMarg3(3) = max(squeeze(mean(squeeze(InfoMat2(3,area1,area2,sstim,stim2,18:19,15:16,1)),1)),[],2);
            MaxMarg3(4) = max(squeeze(mean(squeeze(InfoMat2(4,area1,area2,sstim,stim2,11:12,10:13,1)),1)),[],2);
            MaxMarg3(5) = max(squeeze(mean(squeeze(InfoMat2(5,area1,area2,sstim,stim2,23:24,13:14,1)),1)),[],2);
            MaxMarg3(6) = max(squeeze(mean(squeeze(InfoMat2(6,area1,area2,sstim,stim2,6:7,11:12,1)),1)),[],2);

            MaxMarg4(1) = max(squeeze(mean(squeeze(InfoMat2(1,area2,area1,sstim,stim2,8:9,9:10,1)),1)),[],2);
            MaxMarg4(2) = max(squeeze(mean(squeeze(InfoMat2(2,area2,area1,sstim,stim2,8:9,14:16,1)),1)),[],2);
            MaxMarg4(3) = max(squeeze(mean(squeeze(InfoMat2(3,area2,area1,sstim,stim2,18:19,15:16,1)),1)),[],2);
            MaxMarg4(4) = max(squeeze(mean(squeeze(InfoMat2(4,area2,area1,sstim,stim2,11:12,10:13,1)),1)),[],2);
            MaxMarg4(5) = max(squeeze(mean(squeeze(InfoMat2(5,area2,area1,sstim,stim2,23:24,13:14,1)),1)),[],2);
            MaxMarg4(6) = max(squeeze(mean(squeeze(InfoMat2(6,area2,area1,sstim,stim2,6:7,11:12,1)),1)),[],2);
   
    elseif area1 == 5  
        sstim = stim1_1;

        MaxMarg1(1) = max(squeeze(mean(squeeze(InfoMat(1,area1,area2,sstim,stim2,2:3,4:5,1)),1)),[],2);
        MaxMarg1(2) = max(squeeze(mean(squeeze(InfoMat(2,area1,area2,sstim,stim2,4:5,5:6,1)),1)),[],2);
        MaxMarg1(3) = max(squeeze(mean(squeeze(InfoMat(3,area1,area2,sstim,stim2,3:6,5:6,1)),1)),[],2);
        MaxMarg1(4) = max(squeeze(mean(squeeze(InfoMat(4,area1,area2,sstim,stim2,3:6,6:7,1)),1)),[],2);
        MaxMarg1(5) = max(squeeze(mean(squeeze(InfoMat(5,area1,area2,sstim,stim2,3:4,5:6,1)),1)),[],2);
        MaxMarg1(6) = max(squeeze(mean(squeeze(InfoMat(6,area1,area2,sstim,stim2,6:7,4:5,1)),1)),[],2);

        MaxMarg2(1) = max(squeeze(mean(squeeze(InfoMat(1,area2,area1,sstim,stim2,2:3,4:5,1)),1)),[],2);
        MaxMarg2(2) = max(squeeze(mean(squeeze(InfoMat(2,area2,area1,sstim,stim2,4:5,5:6,1)),1)),[],2);
        MaxMarg2(3) = max(squeeze(mean(squeeze(InfoMat(3,area2,area1,sstim,stim2,3:6,5:6,1)),1)),[],2);
        MaxMarg2(4) = max(squeeze(mean(squeeze(InfoMat(4,area2,area1,sstim,stim2,3:6,6:7,1)),1)),[],2);
        MaxMarg2(5) = max(squeeze(mean(squeeze(InfoMat(5,area2,area1,sstim,stim2,3:4,5:6,1)),1)),[],2);
        MaxMarg2(6) = max(squeeze(mean(squeeze(InfoMat(6,area2,area1,sstim,stim2,6:7,4:5,1)),1)),[],2);

        MaxMarg3(1) = max(squeeze(mean(squeeze(InfoMat2(1,area1,area2,sstim,stim2,2:3,4:5,1)),1)),[],2);
        MaxMarg3(2) = max(squeeze(mean(squeeze(InfoMat2(2,area1,area2,sstim,stim2,4:5,5:6,1)),1)),[],2);
        MaxMarg3(3) = max(squeeze(mean(squeeze(InfoMat2(3,area1,area2,sstim,stim2,3:6,5:6,1)),1)),[],2);
        MaxMarg3(4) = max(squeeze(mean(squeeze(InfoMat2(4,area1,area2,sstim,stim2,3:6,6:7,1)),1)),[],2);
        MaxMarg3(5) = max(squeeze(mean(squeeze(InfoMat2(5,area1,area2,sstim,stim2,3:4,5:6,1)),1)),[],2);
        MaxMarg3(6) = max(squeeze(mean(squeeze(InfoMat2(6,area1,area2,sstim,stim2,6:7,4:5,1)),1)),[],2);

        MaxMarg4(1) = max(squeeze(mean(squeeze(InfoMat2(1,area2,area1,sstim,stim2,2:3,4:5,1)),1)),[],2);
        MaxMarg4(2) = max(squeeze(mean(squeeze(InfoMat2(2,area2,area1,sstim,stim2,4:5,5:6,1)),1)),[],2);
        MaxMarg4(3) = max(squeeze(mean(squeeze(InfoMat2(3,area2,area1,sstim,stim2,3:6,5:6,1)),1)),[],2);
        MaxMarg4(4) = max(squeeze(mean(squeeze(InfoMat2(4,area2,area1,sstim,stim2,3:6,6:7,1)),1)),[],2);
        MaxMarg4(5) = max(squeeze(mean(squeeze(InfoMat2(5,area2,area1,sstim,stim2,3:4,5:6,1)),1)),[],2);
        MaxMarg4(6) = max(squeeze(mean(squeeze(InfoMat2(6,area2,area1,sstim,stim2,6:7,4:5,1)),1)),[],2);
    end

%         if sstim == stim1_1
%             sgtitle([name_area1,'\rightarrow',name_area2,', Somat. stim.'],'FontSize',18);  
%         elseif sstim == stim1_2
%             sgtitle([name_area1,'\rightarrow',name_area2,', Vis. stim.'],'FontSize',18);  
%         end
    
    M1 = mean(MaxMarg1);
    S1 = std(MaxMarg1)./sqrt(length(mean(MaxMarg1)));
    MaxMargPlot1 = [M1-S1, M1, M1+S1]';    
    M2 = mean(MaxMarg2);
    S2 = std(MaxMarg2)./sqrt(length(mean(MaxMarg2)));
    MaxMargPlot2 = [M2-S2, M2, M2+S2]';   
    M3 = mean(MaxMarg3);
    S3 = std(MaxMarg3)./sqrt(length(mean(MaxMarg3)));
    MaxMargPlot3 = [M3-S3, M3, M3+S3]';
    M4 = mean(MaxMarg4);
    S4 = std(MaxMarg4)./sqrt(length(mean(MaxMarg4)));
    MaxMargPlot4 = [M4-S4, M4, M4+S4]';
   g = figure;
    g.Position = [360,198,727.7,320]; 
    subplot(1,2,1);
%     boxplot([MaxMargPlot1 MaxMargPlot2], 'Colors', 'rb', 'Symbol', 'g+');
    hold on
    errorbar(1.25, M1,S1,'o','Color', 'red', 'LineWidth', 3, 'MarkerFaceColor','red', 'MarkerSize', 10);
    errorbar(1.75, M2,S2,'o','Color', [50, 201, 199]/255, 'LineWidth', 3, 'MarkerFaceColor', [50, 201, 199]/255, 'MarkerSize', 10);
    xlim([1, 2])
    if YLIM(2)>0, ylim(YLIM), end

    [~,p2] = ttest(MaxMarg1,MaxMarg2);
%     p2(p2 > 0.05) = NaN;
    sigstar({[1.25,1.75]},p2,YLIM(2));
    
    xticks([1.25, 1.75])
    set(gca, 'XTickLabel', {'Fwd', 'Bwd'});
    set(gca,'FontSize',18);
    set(gca,'linewidth',2);
    set(gca,'Box','on')
    ylabel('(bits)')
    set(gca, 'YTickLabel', get(gca, 'YTick'));
    set(findobj(gca,'type','line'),'linew',2)
        box off

    title('DI','FontSize',16);  
    
%     set(gca,'OuterPosition',[0.069,0.011,0.40,0.89]);
%     set(gca,'InnerPosition',[0.19,0.11,0.27,0.72]);
    subplot(1,2,2);
    hold on
    errorbar(1.25, M3,S3,'o','Color', 'red', 'LineWidth', 3, 'MarkerFaceColor','red', 'MarkerSize', 10);
    errorbar(1.75, M4,S4,'o','Color', [50, 201, 199]/255, 'LineWidth', 3, 'MarkerFaceColor',[50, 201, 199]/255, 'MarkerSize', 10);
    xlim([1, 2])
    if YLIM(2)>0, ylim(YLIM), end

    [~,p2] = ttest(MaxMarg3,MaxMarg4);
%     p2(p2 > 0.05) = NaN;
    sigstar({[1.25,1.75]},p2,YLIM(2));
    
%     set(gca, 'XTickLabel', {['{',stims_names{stim1_1},',',stims_names{stim2},'}'], ['{',stims_names{stim1_2},',',stims_names{stim2},'}']});
    xticks([1.25, 1.75])
    set(gca, 'XTickLabel', {'Fwd', 'Bwd'});
    
    set(gca,'FontSize',18);
    set(gca,'linewidth',2);
    set(gca,'Box','on')
%     ylabel('(bits)')
    set(gca, 'YTickLabel', get(gca, 'YTick'));
    set(findobj(gca,'type','line'),'linew',2);
    box off
    title('FIT','FontSize',14);  

%     set(gca,'OuterPosition',[0.53,0.008,0.4,0.9]);
%     set(gca,'InnerPosition',[0.64,0.11,0.26,0.73]);
    
end
        
end