function [FIT2D, FIT1c,FIT_uniqueZ,pXYhYhZS,specSurprisehY] = dependentFIT_correction(S,X,Z,hY,Y,FITS,FITY,FITSQe, FITYQe, DoQe, FITSval,FITYval)
% There is the possibility of choosing the lattice based on the non-shuffled
% FIT minimization but then the shuffled value on that lattice has to be used 
% to compute FITSh_1c

% FITS, FITY are those based on which we choose the lattice
% FITSval, FITYval are the values from which we subtract the FIT_uniqueZ
% atom. FIT and FITval might only differ when doing the permutations for
% the null hypothesis

if nargin < 11
    FITSval = FITS;
    FITYval = FITY;
end
if DoQe == 0
    FITSQe = -1;
    FITYQe = -1;
end

FIT2DQe = -1;
FIT1cQe = -1; 

if FITS < FITY
    [~, ~, FIT2D,  ~, FIT_uniqueZ, ~,pXYhYhZS,specSurprisehY] = computeInfQuantities_2dsource(S, X, Y, hY, Z, DoQe);                     
    FIT1c = FITSval - FIT_uniqueZ;
    %FIT1cQe = FITSQe - FIT_uniqueZQe;
elseif FITS >= FITY
    [~, ~, FIT2D,  ~, FIT_uniqueZ, ~,pXYhYhZS,specSurprisehY] = computeInfQuantities_2dsource(Y, X, S, hY, Z, DoQe);                     
    FIT1c = FITYval - FIT_uniqueZ;
end

end