function [ pval ] = pValGauss1D(  values, shuffledValues, parallelWorkers )
%PVALGAUSS3D Summary of this function goes here
%   Detailed explanation goes here

pval = zeros(size(values));
size1 = size(pval, 1);

if (parallelWorkers > 1)
    
    numWorkers = parallelWorkers;
    
    %% Start pool with correct number of workers 
    if (numWorkers > 1)
        if (isempty(gcp('nocreate')))
            parpool(numWorkers);
        else
            poolTemp = gcp;
            if(poolTemp.NumWorkers < numWorkers)
                delete(gcp)
                parpool(numWorkers);
            end
        end
    end
    
    %% P value computation itself
    parfor j = 1:size1
        pd = fitdist(squeeze(shuffledValues(j,:)), 'Normal');
        pval(j) = cdf(pd, pd.mu - (values(j) - pd.mu));
    end

else
    %% P value computation itself
    for j = 1:size(pval, 1)
        pd = fitdist(squeeze(shuffledValues(j,:)), 'Normal');
        pval(j) = cdf(pd, pd.mu - (values(j) - pd.mu));
    end
end

end