function [] = plotPanelB(AREA_LIST,post_stim_time_vector,FIT_MAT_EXP_SC, Tactile)

figname = 'FIT';
hFITf=figure('Name',figname,'units','normalized','outerposition',[0.3 0.3 0.3 0.5]);
axes('Position',[.1 .40 .75 .25])
set(gca,'FontSize',16);
set(gca,'linewidth',2);
set(gca,'Box','off')
xlabel('Time (ms)')
ylabel('(bits)')
ColorLineAreasStims = {'r', 'b', 'c', 'm'};
title(figname,'FontSize',16);
hold on;
post_stim_time_vector = post_stim_time_vector(1:21);
STIM1_LIST = [7,5];
stim2 = 1;
AREA_COUPLES = [AREA_LIST; fliplr(AREA_LIST)];
j = 1;
for k = 1:size(AREA_COUPLES,1)
        area1 = AREA_COUPLES(k,1);
        area2 = AREA_COUPLES(k,2);
        for stim1 = STIM1_LIST
            for i=1:6
                FIT = squeeze(FIT_MAT_EXP_SC(i,area1,area2,stim1,1,:,:,1));
                avg1(j,i,:) = avgAcrossDelays(FIT');
                hold on
            end
            stdu(j,:) = std(squeeze(avg1(j,:,:)),0,1)/6;
            shadedErrorBar(post_stim_time_vector(1:21),squeeze(mean(squeeze(avg1(j,:,1:21)),1)),stdu(j,1:21),...
                'lineprops',ColorLineAreasStims{j})
            j = j+1;
        end
end
    set(gca, 'YTickLabel', get(gca, 'YTick'));
if Tactile
    lgdFIT = legend('Tactile, VPM \rightarrow S1','Visual, VPM \rightarrow S1',...
        'Tactile, S1 \rightarrow VPM','Visual, S1 \rightarrow VPM');
else
    lgdFIT = legend('Tactile, LGN \rightarrow V1','Visual, LGN \rightarrow V1',...
        'Tactile, V1 \rightarrow LGN','Visual, V1 \rightarrow LGN');
end
end